% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postestimate_test_MGD.R
\name{testMGD}
\alias{testMGD}
\title{Tests for multi-group comparisons}
\usage{
testMGD(
 .object                = NULL,
 .alpha                 = 0.05,
 .approach_p_adjust     = "none",
 .approach_mgd          = c("all", "Klesel", "Chin", "Sarstedt", 
                            "Keil", "Nitzl", "Henseler", "CI_para","CI_overlap"),
 .output_type           = c("complete", "structured"),
 .parameters_to_compare = NULL,
 .eval_plan             = c("sequential", "multicore", "multisession"),                           
 .handle_inadmissibles  = c("replace", "drop", "ignore"),
 .R_permutation         = 499,
 .R_bootstrap           = 499,
 .saturated             = FALSE,
 .seed                  = NULL,
 .type_ci               = "CI_percentile",
 .type_vcv              = c("indicator", "construct"),
 .verbose               = TRUE
 )
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.alpha}{An integer or a numeric vector of significance levels.
Defaults to \code{0.05}.}

\item{.approach_p_adjust}{Character string or a vector of character strings.
Approach used to adjust the p-value for multiple testing.
See the \code{methods} argument of \code{\link[stats:p.adjust]{stats::p.adjust()}} for a list of choices and
their description. Defaults to "\emph{none}".}

\item{.approach_mgd}{Character string or a vector of character strings.
Approach used for the multi-group comparison. One of: "\emph{all}", "\emph{Klesel}", "\emph{Chin}",
"\emph{Sarstedt}", "\emph{Keil}, "\emph{Nitzl}", "\emph{Henseler}", "\emph{CI_para}", or "\emph{CI_overlap}".
Default to "\emph{all}" in which case all approaches are computed (if possible).}

\item{.output_type}{Character string. The type of output to return. One of
"\emph{complete}" or "\emph{structured}". See the Value section for details. Defaults to
"\emph{complete}".}

\item{.parameters_to_compare}{A model in \link[lavaan:model.syntax]{lavaan model syntax} indicating which
parameters (i.e, path (\code{~}), loadings (\verb{=~}), weights (\verb{<~}), or correlations (\verb{~~})) should be
compared across groups. Defaults to \code{NULL} in which case all weights, loadings and
path coefficients of the originally specified model are compared.}

\item{.eval_plan}{Character string. The evaluation plan to use. One of
"\emph{sequential}", "\emph{multicore}", or "\emph{multisession}". In the two latter cases
all available cores will be used. Defaults to "\emph{sequential}".}

\item{.handle_inadmissibles}{Character string. How should inadmissible results
be treated? One of "\emph{drop}", "\emph{ignore}", or "\emph{replace}". If "\emph{drop}", all
replications/resamples yielding an inadmissible result will be dropped
(i.e. the number of results returned will potentially be less than \code{.R}).
For "\emph{ignore}" all results are returned even if all or some of the replications
yielded inadmissible results (i.e. number of results returned is equal to \code{.R}).
For "\emph{replace}" resampling continues until there are exactly \code{.R} admissible solutions.
Defaults to "\emph{replace}" to accommodate all approaches.}

\item{.R_permutation}{Integer. The number of permutations. Defaults to \code{499}}

\item{.R_bootstrap}{Integer. The number of bootstrap runs. Ignored if \code{.object}
contains resamples. Defaults to \code{499}}

\item{.saturated}{Logical. Should a saturated structural model be used?
Defaults to \code{FALSE}.}

\item{.seed}{Integer or \code{NULL}. The random seed to use. Defaults to \code{NULL} in which
case an arbitrary seed is chosen. Note that the scope of the seed is limited
to the body of the function it is used in. Hence, the global seed will
not be altered!}

\item{.type_ci}{Character string. Which confidence interval should be calculated?
For possible choices, see the \code{.quantity} argument of the \code{\link[=infer]{infer()}} function.
Only used if \code{.approch_mgd} is one of "\emph{CI_para}" or "\emph{CI_overlap}". Ignored otherwise.
Defaults to "\emph{CI_percentile}".}

\item{.type_vcv}{Character string. Which model-implied correlation
matrix should be calculated?
One of "\emph{indicator}" or "\emph{construct}". Defaults to "\emph{indicator}".}

\item{.verbose}{Logical. Should information (e.g., progress bar) be printed
to the console? Defaults to \code{TRUE}.}
}
\value{
If \code{.output_type = "complete"} a list of class \code{cSEMTestMGD}. Technically, \code{cSEMTestMGD} is a
named list containing the following list elements:

\describe{
\item{\verb{$Information}}{Additional information.}
\item{\verb{$Klesel}}{A list with elements, \code{Test_statistic}, \code{P_value}, and \code{Decision}}
\item{\verb{$Chin}}{A list with elements, \code{Test_statistic}, \code{P_value}, \code{Decision}, and \code{Decision_overall}}
\item{\verb{$Sarstedt}}{A list with elements, \code{Test_statistic}, \code{P_value}, \code{Decision}, and \code{Decision_overall}}
\item{\verb{$Keil}}{A list with elements, \code{Test_statistic}, \code{P_value}, \code{Decision}, and \code{Decision_overall}}
\item{\verb{$Nitzl}}{A list with elements, \code{Test_statistic}, \code{P_value}, \code{Decision}, and \code{Decision_overall}}
\item{\verb{$Henseler}}{A list with elements, \code{Test_statistic}, \code{P_value}, \code{Decision}, and \code{Decision_overall}}
\item{\verb{$CI_para}}{A list with elements,  \code{Decision}, and \code{Decision_overall}}
\item{\verb{$CI_overlap}}{A list with elements,  \code{Decision}, and \code{Decision_overall}}
}

If \code{.output_type = "structured"} a tibble (data frame) with the following columns
is returned.

\describe{
\item{\code{Test}}{The name of the test.}
\item{\code{Comparision}}{The parameter that was compared across groups. If "overall"
the overall fit of the model was compared.}
\item{\verb{alpha\%}}{The test decision for a given "alpha" level. If \code{TRUE} the null
hypotheses was rejected; if FALSE it was not rejected.}
\item{\code{p-value_correction}}{The p-value correction.}
\item{\code{CI_type}}{Only for the "CI_para" and the "CI_overlap" test. Which confidence interval was used.}
\item{\code{Distance_metric}}{Only for Test = "Klesel". Which distance metric was used.}
}
}
\description{
\lifecycle{stable}
}
\details{
This function performs various tests proposed in the context of multigroup analysis.

The following tests are implemented:
\describe{
\item{\code{.approach_mgd = "Klesel"}: Approach suggested by \insertCite{Klesel2019;textual}{cSEM}}{
The model-implied variance-covariance matrix (either indicator
(\code{.type_vcv = "indicator"}) or construct (\code{.type_vcv = "construct"}))
is compared across groups. If the model-implied indicator or construct correlation
matrix based on a saturated structural model should be compared, set \code{.saturated = TRUE}.
To measure the distance between the model-implied variance-covariance matrices,
the geodesic distance (dG) and the squared Euclidean distance (dL) are used.
If more than two groups are compared, the average distance over all groups
is used.}
\item{\code{.approach_mgd = "Sarstedt"}: Approach suggested by \insertCite{Sarstedt2011;textual}{cSEM}}{
Groups are compared in terms of parameter differences across groups.
\insertCite{Sarstedt2011;textual}{cSEM} tests if parameter k is equal
across all groups. If several parameters are tested simultaneously
it is recommended to adjust the significance  level or the p-values (in \pkg{cSEM} correction is
done by p-value). By default
no multiple testing correction is done, however, several common
adjustments are available via \code{.approach_p_adjust}. See
\code{\link[stats:p.adjust]{stats::p.adjust()}} for details. Note: the
test has some severe shortcomings. Use with caution.}
\item{\code{.approach_mgd = "Chin"}: Approach suggested by \insertCite{Chin2010;textual}{cSEM}}{
Groups are compared in terms of parameter differences across groups.
\insertCite{Chin2010;textual}{cSEM} tests if parameter k is equal
between two groups. If more than two groups are tested for equality, parameter
k is compared between all pairs of groups. In this case, it is recommended
to adjust the significance  level or the p-values (in \pkg{cSEM} correction is
done by p-value) since this is essentially a multiple testing setup.
If several parameters are tested simultaneously, correction is by group
and number of parameters. By default
no multiple testing correction is done, however, several common
adjustments are available via \code{.approach_p_adjust}. See
\code{\link[stats:p.adjust]{stats::p.adjust()}} for details.}
\item{\code{.approach_mgd = "Keil"}: Approach suggested by \insertCite{Keil2000;textual}{cSEM}}{
Groups are compared in terms of parameter differences across groups.
\insertCite{Keil2000;textual}{cSEM} tests if parameter k is equal
between two groups. It is assumed, that the standard errors of the coefficients are
equal across groups. The calculation of the standard error of the parameter
difference is adjusted as proposed by \insertCite{Henseler2009;textual}{cSEM}.
If more than two groups are tested for equality, parameter k is compared
between all pairs of groups. In this case, it is recommended
to adjust the significance  level or the p-values (in \pkg{cSEM} correction is
done by p-value) since this is essentially a multiple testing setup.
If several parameters are tested simultaneously, correction
is by group and number of parameters. By default
no multiple testing correction is done, however, several common
adjustments are available via \code{.approach_p_adjust}. See
\code{\link[stats:p.adjust]{stats::p.adjust()}} for details.}
\item{\code{.approach_mgd = "Nitzl"}: Approach suggested by \insertCite{Nitzl2010;textual}{cSEM}}{
Groups are compared in terms of parameter differences across groups.
Similarly to \insertCite{Keil2000;textual}{cSEM}, a single parameter k is tested
for equality between two groups. In contrast to \insertCite{Keil2000;textual}{cSEM},
it is assumed, that the standard errors of the coefficients are
unequal across groups \insertCite{Sarstedt2011}{cSEM}.
If more than two groups are tested for equality, parameter k is compared
between all pairs of groups. In this case, it is recommended
to adjust the significance  level or the p-values (in \pkg{cSEM} correction is
done by p-value) since this is essentially a multiple testing setup.
If several parameters are tested simultaneously, correction
is by group and number of parameters. By default
no multiple testing correction is done, however, several common
adjustments are available via \code{.approach_p_adjust}. See
\code{\link[stats:p.adjust]{stats::p.adjust()}} for details.}
\item{\code{.approach_mgd = "Henseler"}: Approach suggested by \insertCite{Henseler2007a;textual}{cSEM}}{
Groups are compared in terms of parameter differences across groups.
In doing so, the bootstrap estimates of one parameter are compared across groups.
In the literature, this approach is also known as PLS-MGA.
Originally, this test was proposed as an one-sided test.
In this function we perform a left-sided and a right-sided test
to investigate whether a parameter differs across two groups. In doing so, the significance
level is divided by 2 and compared to p-value of the left and right-sided test.
Moreover, \code{.approach_p_adjust} is ignored and no overall decision
is returned.
For a more detailed description, see also \insertCite{Henseler2009;textual}{cSEM}.}
\item{\code{.approach_mgd = "CI_param"}: Approach mentioned in \insertCite{Sarstedt2011;textual}{cSEM}}{
This approach is based on the confidence intervals constructed around the
parameter estimates of the two groups. If the parameter of one group falls within
the confidence interval of the other group and/or vice versa, it can be concluded
that there is no group difference.
Since it is based on the confidence intervals \code{.approach_p_adjust} is ignored.}
\item{\code{.approach_mgd = "CI_overlap"}: Approach mentioned in \insertCite{Sarstedt2011;textual}{cSEM}}{
This approach is based on the confidence intervals (CIs) constructed around the
parameter estimates of the two groups. If the two CIs overlap, it can be concluded
that there is no group difference.
Since it is based on the confidence intervals \code{.approach_p_adjust} is ignored.}
}

Use \code{.approach_mgd} to choose the approach. By default all approaches are computed
(\code{.approach_mgd = "all"}).

For convenience, two types of output are available. See the "Value" section below.

By default, approaches based on parameter differences across groups compare
all parameters (\code{.parameters_to_compare = NULL}). To compare only
a subset of parameters provide the parameters in \link[lavaan:model.syntax]{lavaan model syntax}  just like
the model to estimate. Take the simple model:

\preformatted{
model_to_estimate <- "
Structural model
eta2 ~ eta1
eta3 ~ eta1 + eta2

# Each concept os measured by 3 indicators, i.e., modeled as latent variable
eta1 =~ y11 + y12 + y13
eta2 =~ y21 + y22 + y23
eta3 =~ y31 + y32 + y33
"
}
If only the path from eta1 to eta3 and the loadings of eta1 are to be compared
across groups, write:
\preformatted{
to_compare <- "
Structural parameters to compare
eta3 ~ eta1

# Loadings to compare
eta1 =~ y11 + y12 + y13
"
}
Note that the "model" provided to \code{.parameters_to_compare}
does not need to be an estimable model!

Note also that compared to all other functions in \pkg{cSEM} using the argument,
\code{.handle_inadmissibles} defaults to \code{"replace"} to accommodate the Sarstedt et al. (2011) approach.

Argument \code{.R_permuation} is ignored for the \code{"Nitzl"} and the \code{"Keil"} approach.
\code{.R_bootstrap} is ignored if  \code{.object} already contains resamples,
i.e. has class \code{cSEMResults_resampled} and if only the \code{"Klesel"} or the \code{"Chin"}
approach are used.

The argument \code{.saturated} is used by \code{"Klesel"} only. If \code{.saturated = TRUE}
the original structural model is ignored and replaced by a saturated model,
i.e. a model in which all constructs are allowed to correlate freely.
This is useful to test differences in the measurement models between groups
in isolation.
}
\examples{
\dontrun{
# ===========================================================================
# Basic usage
# ===========================================================================
model <- "
# Structural model
QUAL ~ EXPE
EXPE ~ IMAG
SAT  ~ IMAG + EXPE + QUAL + VAL
LOY  ~ IMAG + SAT
VAL  ~ EXPE + QUAL

# Measurement model

EXPE <~ expe1 + expe2 + expe3 + expe4 + expe5
IMAG <~ imag1 + imag2 + imag3 + imag4 + imag5
LOY  =~ loy1  + loy2  + loy3  + loy4
QUAL =~ qual1 + qual2 + qual3 + qual4 + qual5
SAT  <~ sat1  + sat2  + sat3  + sat4
VAL  <~ val1  + val2  + val3  + val4
"

## Create list of virtually identical data sets
dat <- list(satisfaction[-3,], satisfaction[-5, ], satisfaction[-10, ])
out <- csem(dat, model, .resample_method = "bootstrap", .R = 40) 

## Test 
testMGD(out, .R_permutation = 40,.verbose = FALSE)

# Notes: 
#  1. .R_permutation (and .R in the call to csem) is small to make examples run quicker; 
#     should be higher in real applications.
#  2. Test will not reject their respective H0s since the groups are virtually
#     identical.
#  3. Only exception is the approach suggested by Sarstedt et al. (2011), a
#     sign that the test is unreliable.
#  4. As opposed to other functions involving the argument, 
#     '.handle_inadmissibles' the default is "replace" as this is
#     required by Sarstedt et al. (2011)'s approach.

# ===========================================================================
# Extended usage
# ===========================================================================
### Test only a subset ------------------------------------------------------
# By default all parameters are compared. Select a subset by providing a 
# model in lavaan model syntax:

to_compare <- "
# Path coefficients
QUAL ~ EXPE

# Loadings
EXPE <~ expe1 + expe2 + expe3 + expe4 + expe5
"

## Test 
testMGD(out, .parameters_to_compare = to_compare, .R_permutation = 20, 
        .R_bootstrap = 20, .verbose = FALSE)

### Different p_adjustments --------------------------------------------------
# To adjust p-values to accommodate multiple testing use .approach_p_adjust. 
# The number of tests to use for adjusting depends on the approach chosen. For
# the Chin approach for example it is the number of parameters to test times the
# number of possible group comparisons. To compare the results for different
# adjustments, a vector of p-adjustments may be chosen.

## Test 
testMGD(out, .parameters_to_compare = to_compare, 
        .approach_p_adjust = c("none", "bonferroni"),
        .R_permutation = 20, .R_bootstrap = 20, .verbose = FALSE)
}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=csem]{csem()}}, \link{cSEMResults}, \code{\link[=testMICOM]{testMICOM()}}, \code{\link[=testOMF]{testOMF()}}
}
