% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postestimate_test_OMF.R
\name{testOMF}
\alias{testOMF}
\title{Test for overall model fit}
\usage{
testOMF(
 .object                = NULL, 
 .alpha                 = 0.05,
 .fit_measures          = FALSE,
 .handle_inadmissibles  = c("drop", "ignore", "replace"), 
 .R                     = 499, 
 .saturated             = FALSE,
 .seed                  = NULL,
 .verbose               = TRUE
)
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.alpha}{An integer or a numeric vector of significance levels.
Defaults to \code{0.05}.}

\item{.fit_measures}{Logical. (EXPERIMENTAL) Should additional fit measures
be included? Defaults to \code{FALSE}.}

\item{.handle_inadmissibles}{Character string. How should inadmissible results
be treated? One of "\emph{drop}", "\emph{ignore}", or "\emph{replace}". If "\emph{drop}", all
replications/resamples yielding an inadmissible result will be dropped
(i.e. the number of results returned will potentially be less than \code{.R}).
For "\emph{ignore}" all results are returned even if all or some of the replications
yielded inadmissible results (i.e. number of results returned is equal to \code{.R}).
For "\emph{replace}" resampling continues until there are exactly \code{.R} admissible solutions.
Depending on the frequency of inadmissible solutions this may significantly increase
computing time. Defaults to "\emph{drop}".}

\item{.R}{Integer. The number of bootstrap replications. Defaults to \code{499}.}

\item{.saturated}{Logical. Should a saturated structural model be used?
Defaults to \code{FALSE}.}

\item{.seed}{Integer or \code{NULL}. The random seed to use. Defaults to \code{NULL} in which
case an arbitrary seed is chosen. Note that the scope of the seed is limited
to the body of the function it is used in. Hence, the global seed will
not be altered!}

\item{.verbose}{Logical. Should information (e.g., progress bar) be printed
to the console? Defaults to \code{TRUE}.}
}
\value{
A list of class \code{cSEMTestOMF} containing the following list elements:
\describe{
\item{\verb{$Test_statistic}}{The value of the test statistics.}
\item{\verb{$Critical_value}}{The corresponding  critical values obtained by the bootstrap.}
\item{\verb{$Decision}}{The test decision. One of: \code{FALSE} (\strong{Reject}) or \code{TRUE} (\strong{Do not reject}).}
\item{\verb{$Information}}{The \code{.R} bootstrap values; The number of admissible results;
The seed used and the number of total runs.}
}
}
\description{
\lifecycle{maturing}
}
\details{
Bootstrap-based test for overall model fit originally proposed by \insertCite{Beran1985;textual}{cSEM}.
See also \insertCite{Dijkstra2015;textual}{cSEM} who first suggested the test in
the context of PLS-PM.

By default, \code{testOMF()} tests the null hypothesis that the population indicator
correlation matrix equals the population model-implied indicator correlation matrix.
Several discrepancy measures may be used. By default, \code{testOMF()} uses four distance
measures to assess the distance between the sample indicator correlation matrix
and the estimated model-implied indicator correlation matrix, namely the geodesic distance,
the squared Euclidean distance, the standardized root mean square residual (SRMR),
and the distance based on the maximum likelihood fit function.
The reference distribution for each test statistic is obtained by
the bootstrap as proposed by \insertCite{Beran1985;textual}{cSEM}.

It is possible to perform the bootstrap-based test using fit measures such
as the CFI, RMSEA or the GFI if \code{.fit_measures = TRUE}. This is experimental.
To the best of our knowledge the applicability and usefulness of the fit
measures for model fit assessment have not been formally (statistically)
assessed yet. Theoretically, the logic of the test applies to these fit indices as well.
Hence, their applicability is theoretically justified.
Only use if you know what you are doing.

If \code{.saturated = TRUE} the original structural model is ignored and replaced by
a saturated model, i.e., a model in which all constructs are allowed to correlate freely.
This is useful to test misspecification of the measurement model in isolation.
}
\examples{
\donttest{# ===========================================================================
# Basic usage
# ===========================================================================
model <- "
# Structural model
eta2 ~ eta1
eta3 ~ eta1 + eta2

# (Reflective) measurement model
eta1 =~ y11 + y12 + y13
eta2 =~ y21 + y22 + y23
eta3 =~ y31 + y32 + y33
"

## Estimate
out <- csem(threecommonfactors, model, .approach_weights = "PLS-PM")

## Test
testOMF(out, .R = 50, .verbose = FALSE, .seed = 320)
}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=csem]{csem()}}, \code{\link[=calculateSRMR]{calculateSRMR()}}, \code{\link[=calculateDG]{calculateDG()}}, \code{\link[=calculateDL]{calculateDL()}}, \link{cSEMResults},
\code{\link[=testMICOM]{testMICOM()}}, \code{\link[=testMGD]{testMGD()}}
}
