% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csem_data.R
\name{processData}
\alias{processData}
\title{Internal: Process data}
\usage{
processData(
  .data        = NULL, 
  .model       = NULL, 
  .instruments = NULL
  )
}
\arguments{
\item{.data}{A \code{data.frame} or a \code{matrix} of standardized or unstandardized
data (indicators/items/manifest variables). Possible column types or classes
of the data provided are: "\code{logical}", "\code{numeric}" ("\code{double}" or "\code{integer}"),
"\code{factor}" ("\code{ordered}" and/or "\code{unordered}"), "\code{character}" (converted to factor),
or a mix of several types.}

\item{.model}{A model in \link[lavaan:model.syntax]{lavaan model syntax}
or a \link{cSEMModel} list.}

\item{.instruments}{A named list of vectors of instruments. The names
of the list elements are the names of the dependent (LHS) constructs of the structural
equation whose explanatory variables are endogenous. The vectors
contain the names of the instruments corresponding to each equation. Note
that exogenous variables of a given equation \strong{must} be supplied as
instruments for themselves. Defaults to \code{NULL}.}
}
\value{
A (N x K) data.frame containing the standardized data with columns ordered
according to the order they appear in the measurement model equations provided
via the \code{.model} argument.
}
\description{
Prepare, standardize, check, and clean data provided via the \code{.data} argument.
}
\keyword{internal}
