% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_infer.R, R/postestimate_infer.R
\name{MeanResample}
\alias{MeanResample}
\alias{SdResample}
\alias{BiasResample}
\alias{StandardCIResample}
\alias{PercentilCIResample}
\alias{BasicCIResample}
\alias{TStatCIResample}
\alias{BcCIResample}
\alias{BcaCIResample}
\alias{infer}
\title{Inference}
\usage{
MeanResample(.first_resample)

SdResample(.first_resample, .resample_method, .n)

BiasResample(.first_resample, .resample_method, .n)

StandardCIResample(
  .first_resample,
  .bias_corrected,
  .dist = c("z", "t"),
  .df = c("type1", "type2"),
  .resample_method,
  .n,
  .probs
)

PercentilCIResample(.first_resample, .probs)

BasicCIResample(.first_resample, .bias_corrected, .probs)

TStatCIResample(
  .first_resample,
  .second_resample,
  .bias_corrected,
  .resample_method,
  .resample_method2,
  .n,
  .probs
)

BcCIResample(.first_resample, .probs)

BcaCIResample(.object, .first_resample, .probs)

infer(
 .object            = NULL,
 .alpha             = 0.05,
 .bias_corrected    = TRUE,
 .quantity          = c("all", "mean", "sd", "bias", "CI_standard_z", 
                        "CI_standard_t", "CI_percentile", "CI_basic", 
                        "CI_bc", "CI_bca", "CI_t_interval")
)
}
\arguments{
\item{.first_resample}{A list containing the \code{.R} resamples based on the original
data obtained by resamplecSEMResults().}

\item{.resample_method}{Character string. The resampling method to use. One of:
"\emph{none}", "\emph{bootstrap}" or "\emph{jackknife}". Defaults to "\emph{none}".}

\item{.n}{Integer. The number of observations of the original data.}

\item{.bias_corrected}{Logical. Should the standard and the tStat
confidence interval be bias-corrected using the bootstrapped bias estimate?
If \code{TRUE} the confidence interval for some estimated parameter \code{theta}
is centered at \verb{2*theta - theta*_hat},
where \verb{theta*_hat} is the average over all \code{.R} bootstrap estimates of \code{theta}.
Defaults to \code{TRUE}}

\item{.dist}{Character string. The distribution to use for the critical value.
One of \emph{"t"} for Student's t-distribution or \emph{"z"} for the standard normal distribution.
Defaults to \emph{"z"}.}

\item{.df}{Character string. The method for obtaining the degrees of freedom.
Choices are "\emph{type1}" and "\emph{type2}". Defaults to "\emph{type1}" .}

\item{.probs}{A vector of probabilities.}

\item{.second_resample}{A list containing \code{.R2} resamples for each of the \code{.R}
resamples of the first run.}

\item{.resample_method2}{Character string. The resampling method to use when resampling
from a resample. One of: "\emph{none}", "\emph{bootstrap}" or "\emph{jackknife}". For
"\emph{bootstrap}" the number of draws is provided via \code{.R2}. Currently,
resampling from each resample is only required for the studentized confidence
intervall ("\emph{CI_t_interval}") computed by the \code{\link[=infer]{infer()}} function. Defaults to "\emph{none}".}

\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.alpha}{An integer or a numeric vector of significance levels.
Defaults to \code{0.05}.}

\item{.quantity}{Character string. Which statistic should be returned?
One of "\emph{all}", "\emph{mean}", "\emph{sd}", "\emph{bias}", "\emph{CI_standard_z}", "\emph{CI_standard_t}",
"\emph{CI_percentile}", "\emph{CI_basic}", "\emph{CI_bc}", "\emph{CI_bca}", "\emph{CI_t_interval}"
Defaults to "\emph{all}" in which case all quantities that do not require
additional resampling are returned, i.e., all quantities but "\emph{CI_bca}", "\emph{CI_t_interval}".}
}
\value{
A list of class \code{cSEMInfer}.
}
\description{
Calculate common inferential quantities. For users interested in the
estimated standard errors and/or confidences intervals \code{\link[=summarize]{summarize()}} will usually
be more helpful as it has a much more user-friendly print method.
}
\details{
Calculate common inferential quantities (e.g., estimated standard errors, estimated bias,
confidence intervals) based on a \code{cSEMResults_resampled} object as obtained
by calling \code{\link[=resamplecSEMResults]{resamplecSEMResults()}} or by setting \code{.resample_method = "bootstrap"}
or \code{"jackknife"} when calling \code{\link[=csem]{csem()}}. Currently, the following quantities are
returned by default (\code{.quantity = "all"}):
\describe{
\item{\code{"mean"}, \code{"sd"} and \code{"bias"}}{The mean, the standard
deviation and the estimated bias (defined as the difference between the resample mean
and the original estimate).}
\item{\code{"CI_standard_z"} and \code{"CI_standard_t"}}{The standard confidence interval
with standard errors estimated by the resample standard deviation.
While \code{"CI_standard_z"} assumes a standard normally distributed statistic,
\code{"CI_standard_t"} assumes a t-statistic with N - 1 degrees of freedom.}
\item{\code{"CI_percentile"}}{The percentile confidence interval}
\item{\code{"CI_basic"}}{The basic confidence interval}
\item{\code{"CI_bc"}}{The bias corrected confidence interval}
}

In addition, the bias-corrected and accelerated (\code{.quantity = "CI_bca"}) and/or the "studentized"
confidence interval (\code{".quantity = CI_t_interval"}) may be computed. The former requires
jackknife estimates to compute influence values and the latter requires
double bootstrap. Both can potentially be time consuming. Hence, computation is triggerd
only if explicitly chosen.
}
\section{Functions}{
\itemize{
\item \code{MeanResample}: Computes the mean over all resamples for each resampled
statistic/parameter.

\item \code{SdResample}: Computes the standard deviation over all resamples for each resampled
statistic/estimator. This is usually taken to be the estimate
of the standard error of the statistic/estimator.

\item \code{BiasResample}: Computes the estimated bias for each resampled
statistic/estimator.

\item \code{StandardCIResample}: Computes the \emph{Standard CI with bootstrap SE's}.
Critical quantiles can be based on both the \code{t}- or the
standard normal distribution (\code{z}). The former may perform better in
small samples but there is no clear consenus on what the degrees of freedom
should be. We use N - 1 ("type1").

\item \code{PercentilCIResample}: Computes the \emph{Percentile CI}.
The function takes the distribution F* (the CDF) of the resamples as an estimator for
the true distribution F of the statistic/estimator of interest.
Quantiles of the estimated distribution are then used as lower and upper bound.

\item \code{BasicCIResample}: Computes the \emph{Basic CI}.

\item \code{TStatCIResample}: Computes the \emph{Studentized or t-statistic CI}
The function computes a boostrap t-statisic (since it is roughly pivotal) and constructs
the CI based on bootstraped t-values and bootstraped/jackknife SE's

\item \code{BcCIResample}: Computes the \emph{Basic bias-corrected CI}.

\item \code{BcaCIResample}: Computes the \emph{Basic bias-corrected and accelerated CI}.
}}

\examples{
\donttest{model <- "
# Structural model
QUAL ~ EXPE
EXPE ~ IMAG
SAT  ~ IMAG + EXPE + QUAL + VAL
LOY  ~ IMAG + SAT
VAL  ~ EXPE + QUAL

# Measurement model
EXPE =~ expe1 + expe2 + expe3 + expe4 + expe5
IMAG =~ imag1 + imag2 + imag3 + imag4 + imag5
LOY  =~ loy1  + loy2  + loy3  + loy4
QUAL =~ qual1 + qual2 + qual3 + qual4 + qual5
SAT  =~ sat1  + sat2  + sat3  + sat4
VAL  =~ val1  + val2  + val3  + val4
"
  
## Estimate the model with bootstrap resampling 
a <- csem(satisfaction, model, .resample_method = "bootstrap", .R = 50)

## Compute inferential quantities
inf <- infer(a)

inf$Path_estimates$CI_basic
inf$Indirect_effect$sd

### To compute the bias-corrected and accelerated and/or the studentized t-inverval
### confidence interval:
inf <- infer(a, .quantity = c("all", "CI_bca")) # requires jackknife estimates

## For the studentied t-interval confidence interval, a double bootstrap is required:
## Estimate the model with double bootstrap resampling:
# Notes:
#   1. The .resample_method2 arguments triggers a bootstrap of each bootstrap sample
#   2. The double bootstrap is is very time consuming, consider setting 
#      `.eval_plan = "multiprocess`. 
#      To speed things up .R and .R2 are reduced for the example. Results are
#      therefore rather unreliable.
a1 <- csem(satisfaction, model, .resample_method = "bootstrap", .R = 40,
          .resample_method2 = "bootstrap", .R2 = 20, .handle_inadmissibles = "replace") 
infer(a1, .quantity = "CI_t_interval")}
}
\seealso{
\code{\link[=csem]{csem()}}, \code{\link[=resamplecSEMResults]{resamplecSEMResults()}}, \code{\link[=summarize]{summarize()}} \link{cSEMResults}
}
\keyword{internal}
