% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaBinomial.R
\name{betaNormTable}
\alias{betaNormTable}
\title{Generate norm table from parametric continuous norming with Beta-Binomial Parameters}
\usage{
betaNormTable(model, group, m = NULL)
}
\arguments{
\item{model}{A list containing the components from a `betaContinuous` model output.}

\item{group}{A number specifying the group variable for which predictions and
subsequent beta-binomial distribution calculations are desired.}

\item{m}{An optional stop criterion in table generation. Positive integer lower than n}
}
\value{
A data frame with columns representing the number of successes (`x`), the probability mass
function values (`Px`), cumulative probabilities (`Pcum`), percentiles (`Percentile`), and
z-scores (`z`) for the specified group based on the predicted `a` and `b` parameters.
}
\description{
This function generates a table of beta-binomial distribution properties (cumulative probabilities,
density, percentiles, and z-scores) for a specified group, using alpha (`a`) and beta (`b`) parameters
predicted by a model created with the `betaContinuous` function.
}
\examples{
# Determies beta parameters and models these continuously
param <- betaByGroup(elfe$raw, elfe$group, 26)
beta.model <- betaContinuous(param, 4, 4)

# Calculates table for new group
newGroup <- 3.9
betaNormTable(beta.model, newGroup)
}
