% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mortality}
\alias{mortality}
\title{Mortality of infants per 1000 life birth from 1960 to 2017}
\format{
A data frame with 9547 rows and 4 variables:
\describe{
  \item{Country}{The name of the country}
  \item{year}{reference year of data collection}
  \item{mortality}{the mortality per 1000 life born children}
  \item{group}{grouping variable based on 'year' with a lower resolution; spans intervals of 4 years each}
}
}
\source{
\url{https://data.worldbank.org/indicator/SP.DYN.IMRT.IN}
}
\usage{
mortality
}
\description{
The data is available by the courtesy of the World Bank under Creative Commons Attribution 4.0 (CC-BY 4.0).
It includes the mortality rate of life birth per country from 1960 to 2017. The data has been converted to
long data format, aggregates for groups of nations and missings have been deleted and a grouping variable
with a broader scope spanning 4 years each has been added. It can be used for demonstrating intersecting
percentile curves at bottom effects.
}
\examples{
\dontrun{
# data preparation
data.mortality <- rankByGroup(mortality, raw="mortality")
data.mortality <- computePowers(data.mortality, age="year")

# modeling
model.mortality <- bestModel(data.mortality, raw="mortality")
plotSubset(model.mortality, type = 0)
plotPercentileSeries(data.mortality, model.mortality, end=9, percentiles = c(.1, .25, .5, .75, .9))
}
}
\references{
The World Bank (2018). Mortality rate, infant (per 1,000 live births). Data Source	available
\url{https://data.worldbank.org/indicator/SP.DYN.IMRT.IN} (date of retrieval: 02/09/2018)
}
\concept{mortality at birth}
\keyword{datasets}
