% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predictRaw}
\alias{predictRaw}
\title{Predict single raw value}
\usage{
predictRaw(norm, age, coefficients, minRaw = -Inf, maxRaw = Inf)
}
\arguments{
\item{norm}{The norm score, e. g. a specific T score}

\item{age}{The age value}

\item{coefficients}{The coefficients from the regression model}

\item{minRaw}{Minimum score for the results; can be used for clipping unrealistic outcomes,
usually set to the lower bound of the range of values of the test (default: 0)}

\item{maxRaw}{Maximum score for the results; can be used for clipping unrealistic outcomes
usually set to the upper bound of the range of values of the test}
}
\value{
the predicted raw score
}
\description{
Most elementary function to predict raw score based on Location (L, T score),
Age (grouping variable) and the coefficients from a regression model.
WARNING! This function, and all functions  depending on it, only works with regression
functions including L, A and interactions. Manually adding predictors to bestModel via the
predictors parameter is currently incompatible.
In that case, and if you are primarily interested on fitting a complete data set,
rather user the predict function of the stats:lm package on the ideal model solution.
You than have to provide a prepared data frame with the according input variables.
}
\examples{
# Prediction of single scores
normData <- prepareData()
m <- bestModel(data = normData)
predictRaw(35, 3.5, m$coefficients)

# Fitting complete data sets
fitted.values <- predict(m)

# break up contribution of each predictor variable
fitted.partial <- predict(m, type = "terms")
}
