% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{TwoPLChoicemcmc}
\alias{TwoPLChoicemcmc}
\title{Two Parameter Choice IRT Model MCMC}
\usage{
TwoPLChoicemcmc(unique_subject_ids, subject_ids, choices_nk, fixed_effects, B,
  rv_effects_design, gamma, beta, zeta_rv, Sigma_zeta_inv, Y, theta0, a0, b0,
  mu_xi0, Sig_xi0)
}
\arguments{
\item{unique_subject_ids}{A \code{vector} with length N x 1 containing unique subject IDs.}

\item{subject_ids}{A \code{vector} with length N*K x 1 containing subject IDs.}

\item{choices_nk}{A \code{vector} with length N*K x 1 containing subject choices.}

\item{fixed_effects}{A \code{matrix} with dimensions N*K x P_1 containing fixed effect design matrix without theta.}

\item{B}{A V dimensional column \code{vector} relating theta_i and zeta_i.}

\item{rv_effects_design}{A \code{matrix} with dimensions N*K x V containing random effect variables.}

\item{gamma}{A \code{vector} with dimensions P x 1 containing fixed parameter estimates, where \eqn{P = P_1 + P_2}}

\item{beta}{A \code{vector} with dimensions \eqn{P_2} containing random parameter estimates.}

\item{zeta_rv}{A \code{matrix} with dimensions N x V containing random parameter estimates.}

\item{Sigma_zeta_inv}{A \code{matrix} with dimensions \eqn{P_2 x P_2}}

\item{Y}{dichotomous item responses, a \code{matrix} of dimensions n x J}

\item{theta0}{latent theta, a \code{vector} of length n}

\item{a0}{item discriminations, a \code{vector} of length J}

\item{b0}{item locations, a \code{vector} of length J}

\item{mu_xi0}{prior for item parameter means, requires a \code{vector} of dimension 2 (i.e. c(0,1))}

\item{Sig_xi0}{prior for item parameter vc matrix, a \code{matrix} of dimension 2x2 (i.e. diag(2))}
}
\value{
A \code{list} that contains:
\describe{
  \item{\code{ai1}}{A \code{vector} of length J}
  \item{\code{bi1}}{A \code{vector} of length J}   
  \item{\code{theta1}}{A \code{vector} of length N}
  \item{\code{Z_c}}{A \code{matrix} of length NK}
  \item{\code{Wzeta_0}}{A \code{matrix} of length NK}
}
}
\description{
Performs an MCMC routine for a two parameter IRT Model using Choice Data
}
\examples{
\dontrun{
#Call with the following data:
TwoPLChoicemcmc(cogDAT,theta0,a0,b0,mu_xi0,Sig_xi0)
}
}
\author{
Steven Culpepper and James J Balamuta
}
\seealso{
\code{\link{cIRT}}, \code{\link{rmvnorm}}, and \code{\link{riwishart}}
}

