% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criteria.R
\name{compute_logml}
\alias{compute_logml}
\alias{compute_logml.bvarmn}
\alias{compute_logml.bvharmn}
\title{Extracting Log of Marginal Likelihood}
\usage{
compute_logml(object, ...)

\method{compute_logml}{bvarmn}(object, ...)

\method{compute_logml}{bvharmn}(object, ...)
}
\arguments{
\item{object}{Model fit}

\item{...}{not used}
}
\value{
log likelihood of Minnesota prior model.
}
\description{
Compute log of marginal likelihood of Bayesian Fit
}
\details{
Closed form of Marginal Likelihood of BVAR can be derived by

\deqn{p(Y_0) = \pi^{-mn / 2} \frac{\Gamma_m ((\alpha_0 + n) / 2)}{\Gamma_m (\alpha_0 / 2)} \det(\Omega_0)^{-m / 2} \det(S_0)^{\alpha_0 / 2} \det(\hat{V})^{- m / 2} \det(\hat{\Sigma}_e)^{-(\alpha_0 + n) / 2}}

Closed form of Marginal Likelihood of BVHAR can be derived by

\deqn{p(Y_0) = \pi^{-ms_0 / 2} \frac{\Gamma_m ((d_0 + n) / 2)}{\Gamma_m (d_0 / 2)} \det(P_0)^{-m / 2} \det(U_0)^{d_0 / 2} \det(\hat{V}_{HAR})^{- m / 2} \det(\hat{\Sigma}_e)^{-(d_0 + n) / 2}}
}
\references{
Giannone, D., Lenza, M., & Primiceri, G. E. (2015). \emph{Prior Selection for Vector Autoregressions}. Review of Economics and Statistics, 97(2).
}
