% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{stoch_vol}
\alias{stoch_vol}
\title{Stochastic Volatility}
\usage{
stoch_vol(y, h, sigma, h_init, constant)
}
\arguments{
\item{y}{a \eqn{T \times 1} vector containing the time series.}

\item{h}{a \eqn{T \times 1} vector of log-volatilities.}

\item{sigma}{a numeric of the variance of the log-volatilites.}

\item{h_init}{a numeric of the initial state of log-volatilities.}

\item{constant}{a numeric of the constant that should be added to \eqn{y^2}
before taking the natural logarithm.}
}
\value{
A vector of log-volatility draws.
}
\description{
Produces a draw of log-volatilities.
}
\details{
The function is a wrapper for function \code{\link{stochvol_ksc1998}}.
}
\examples{
data("us_macrodata")
y <- us_macrodata[, "r"]

# Initialise log-volatilites
h_init <- log(var(y))
h <- rep(h_init, length(y))

# Obtain draw
stoch_vol(y - mean(y), h, .05, h_init, 0.0001)

}
\references{
Chan, J., Koop, G., Poirier, D. J., & Tobias J. L. (2019). \emph{Bayesian econometric methods}
(2nd ed.). Cambridge: Cambridge University Press.

Kim, S., Shephard, N., & Chib, S. (1998). Stochastic volatility. Likelihood inference and comparison
with ARCH models. \emph{Review of Economic Studies 65}(3), 361--393. \doi{10.1111/1467-937X.00050}
}
