% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bvecpost.R
\name{bvecpost}
\alias{bvecpost}
\title{Posterior Simulation for BVEC Models}
\usage{
bvecpost(object)
}
\arguments{
\item{object}{an object of class \code{"bvarmodel"}, usually, a result of a call to \code{\link{gen_var}}
in combination with \code{\link{add_priors}}.}
}
\description{
Produces draws from the posterior distributions of Bayesian VEC models.
}
\details{
The function implements a posterior simulation algorithm, which
places identifying restrictions on the cointegration space. Th algorithm is also able to employ
stochastic search variable selection (SSVS) as proposed by Geroge et al. (2008) or Bayesian
variable selection (BVS) as proposed in Korobilis (2013). Both SSVS and BVS can also be applied to the
covariances of the error term. However, the algorithms cannot be applied to cointegration related
coefficients, i.e. to the loading matrix \eqn{\alpha} or the cointegration matrix \eqn{beta}.

The implementation primarily follows the description in Koop et al. (2010). However, Chan et al. (2019),
George et al. (2008) and Korobilis (2013) were used to implement variable selection algorithms.
For all approaches the SUR form of a VEC model is used to obtain posterior draws. The algorithm is implemented
in C++ to reduce calculation time.

The function also supports structural BVEC models, where the structural coefficients are estimated from
contemporary endogenous variables, which corresponds to the so-called (A-model). Currently, only
specifications are supported, where the structural matrix contains ones on its diagonal and all lower
triangular elements are freely estimated. Since posterior draws are obtained based on the SUR form of
the VAR model, the structural coefficients are drawn jointly with the other coefficients. No identifying
restrictionare are made regarding the cointegration matrix.
}
\examples{

# Get data
data("e6")

# Create model
model <- gen_vec(e6, p = 4, r = 1,
                 const = "unrestricted", seasonal = "unrestricted",
                 iterations = 100, burnin = 10)
# Chosen number of iterations and burnin should be much higher.

# Add priors
model <- add_priors(model)

# Obtain posterior draws 
object <- bvecpost(model)

}
\references{
Chan, J., Koop, G., Poirier, D. J., & Tobias J. L. (2019). \emph{Bayesian econometric methods}
(2nd ed.). Cambridge: Cambridge University Press.

George, E. I., Sun, D., & Ni, S. (2008). Bayesian stochastic search for VAR model
restrictions. \emph{Journal of Econometrics, 142}(1), 553--580.
\doi{10.1016/j.jeconom.2007.08.017}

Koop, G., León-González, R., & Strachan R. W. (2010). Efficient posterior
simulation for cointegrated models with priors on the cointegration space.
\emph{Econometric Reviews, 29}(2), 224--242.
\doi{10.1080/07474930903382208}

Korobilis, D. (2013). VAR forecasting using Bayesian variable selection.
\emph{Journal of Applied Econometrics, 28}(2), 204--230. \doi{10.1002/jae.1271}
}
