% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kknn.R
\name{axe-kknn}
\alias{axe-kknn}
\alias{axe_call.kknn}
\alias{axe_env.kknn}
\alias{axe_fitted.kknn}
\title{Axing an kknn.}
\usage{
\method{axe_call}{kknn}(x, verbose = FALSE, ...)

\method{axe_env}{kknn}(x, verbose = FALSE, ...)

\method{axe_fitted}{kknn}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed kknn object.
}
\description{
kknn objects are created from the \pkg{kknn} package, which is
utilized to do weighted k-Nearest Neighbors for classification,
regression and clustering.
}
\examples{
\dontshow{if (rlang::is_installed(c("parsnip", "rsample", "rpart", "kknn"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Load libraries
library(parsnip)
library(rsample)
library(rpart)
library(kknn)

# Load data
set.seed(1234)
split <- initial_split(kyphosis, prop = 9/10)
spine_train <- training(split)

# Create model and fit
kknn_fit <- nearest_neighbor(mode = "classification",
                             neighbors = 3,
                             weight_func = "gaussian",
                             dist_power = 2) \%>\%
  set_engine("kknn") \%>\%
  fit(Kyphosis ~ ., data = spine_train)

out <- butcher(kknn_fit, verbose = TRUE)

\donttest{
# Another kknn model object
m <- dim(iris)[1]
val <- sample(1:m,
              size = round(m/3),
              replace = FALSE,
              prob = rep(1/m, m))
iris.learn <- iris[-val,]
iris.valid <- iris[val,]
kknn_fit <- kknn(Species ~ .,
                 iris.learn,
                 iris.valid,
                 distance = 1,
                 kernel = "triangular")
out <- butcher(kknn_fit, verbose = TRUE)
}
\dontshow{\}) # examplesIf}
}
