% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_ddb.R
\name{ddb_search}
\alias{ddb_search}
\title{Search Deutsche Digitale Bibliothek}
\usage{
ddb_search(
  query,
  params = list(),
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{query}{Search query string.}

\item{params}{Additional query parameters.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with search metadata and result payload.
}
\description{
Search Deutsche Digitale Bibliothek
}
\details{
Returns search results from the Deutsche Digitale Bibliothek API. You need an
API key from https://www.deutsche-digitale-bibliothek.de/user/apikey. The key
is sent in the \code{Authorization} header as \verb{OAuth oauth_consumer_key="<key>"}.

Configure authentication via \code{\link[=bunddev_auth_set]{bunddev_auth_set()}} using a template-style
scheme, or set the \code{DDB_API_KEY} environment variable directly.
}
\examples{
\dontrun{
# Recommended: use bunddev_auth_set with template scheme
Sys.setenv(DDB_API_KEY = "<api-key>")
bunddev_auth_set("ddb", type = "api_key", env_var = "DDB_API_KEY",
                 scheme = "OAuth oauth_consumer_key=\"\%s\"")
ddb_search(query = "berlin", params = list(rows = 5))
}

}
\seealso{
\code{\link[=bunddev_auth_set]{bunddev_auth_set()}} to configure authentication.
}
