% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossPanel.R
\name{crossPanel}
\alias{crossPanel}
\alias{crossPanelUI}
\alias{crossPanelServer}
\title{Generate the cross plot panel of the shiny app}
\usage{
crossPanelUI(id, metadata)

crossPanelServer(id, expression.matrix, metadata, anno)
}
\arguments{
\item{id}{the input slot that will be used to access the value}

\item{metadata}{a data frame containing metadata for the samples contained
in the expression.matrix; must contain at minimum two columns:
the first column must contain the column names of the expression.matrix,
while the last column is assumed to contain the experimental conditions
that will be tested for differential expression}

\item{expression.matrix}{the expression matrix; rows correspond to genes and
columns correspond to samples; usually preprocessed by
\code{\link{preprocessExpressionMatrix}}}

\item{anno}{annotation data frame containing a match between the row names
of the expression.matrix (usually ENSEMBL IDs) and the gene names that
should be rendered within the app and in output files; this object is
created by \code{\link{generateShinyApp}} using the org.db specified}
}
\value{
The UI and Server components of the shiny module, that can be used
within the UI and Server definitions of a shiny app.
}
\description{
These are the UI and server components of the cross plot panel of the
shiny app. It is generated by including 'Cross' in the panels.default argument
of \code{\link{generateShinyApp}}.
}
