% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatData.R
\name{formatData}
\alias{formatData}
\title{Split Data Into Matrices and Reorder Rows and Columns.}
\usage{
formatData(
  data,
  rowName = "rowName",
  colName = "colName",
  plotGroup = "plotGroup",
  colorValue = "colorValue",
  sizeValue = "sizeValue",
  rowOrder = NULL,
  colOrder = NULL,
  listOrder = NULL,
  nightingale = TRUE
)
}
\arguments{
\item{data}{Dataset containing variables to be plotted on color and size
scales with additional matrix layout specification variables
(see details).}

\item{rowName}{String naming the variable of \code{data} which defines rows
of each matrix.}

\item{colName}{String naming the variable of \code{data} which defines
columns of each matrix.}

\item{plotGroup}{String naming the variable of \code{data} which groups the
dataset into plots.}

\item{colorValue}{String naming the variable of \code{data} containing the
values to be plotted on the color scale.}

\item{sizeValue}{String naming the variable of \code{data} containing the
values to scale bubble sizes.}

\item{rowOrder}{List of vectors of character strings matching the values of
\code{rowName} for each plot. List names should match values of
\code{plotGroup}. Can be \code{NULL} (default) if no sorting required or
when using inbuilt Nightingale ordering. If used, it is not necessary for
all plots to have list entries, but each entry should include all row
names for that plot.}

\item{colOrder}{As \code{rowOrder} for columns and \code{colName}.}

\item{listOrder}{Vector of character strings matching values of
\code{plotGroup} variable, or \code{NULL} (default) if no sorting
required or when using inbuilt Nightingale ordering.}

\item{nightingale}{Logical - use Nightingale style settings?}
}
\value{
A list of two lists of numeric matrices. The matrices in
\code{colorList} contain values of \code{data$colorValue} and those in
\code{sizeList} contain values of \code{data$sizeValue}. The matrice layouts
are defined by \code{data$rowName} and \code{data$colName} and each list has
one item for each unique value of \code{data$plotGroup}.
}
\description{
Prepare data variables for plot building by splitting into matrices and
ordering rows and columns. Includes pre-defined settings for plotting
Nightingale metabolomics data.
}
\details{
This function takes an input dataset with one row for each plot cell
and splits it into a list of plot datasets as defined by the variable
\code{plotGroup}. Each plot dataset is then recast (using the
\code{cast()} function from the \code{reshape} package) into matrices defined
by the \code{colName} and \code{rowName} variables. Two matrices are produced
for each plot, containing the values of \code{colorValue} and
\code{sizeValue} respectively. To use the included Nightingale metabolomics
plot templates, the \code{rowName}, \code{colName} and \code{plotGroup}
variables can be merged from the options in the package datafiles
\code{ntngale225/249}.
}
\examples{
data <- merge_template(cetp, "ckb_id")
formatData(data, colorValue = "estimate", sizeValue = "negLog10P",
nightingale = TRUE)
}
