% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-git.R
\name{btw_tool_git_branch_checkout}
\alias{btw_tool_git_branch_checkout}
\title{Tool: Git Branch Checkout}
\usage{
btw_tool_git_branch_checkout(branch, force = FALSE, `_intent` = "")
}
\arguments{
\item{branch}{Name of branch to check out.}

\item{force}{Whether to force checkout even with uncommitted changes.
Defaults to \code{FALSE}.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
Returns a confirmation message.
}
\description{
Allows an LLM to switch to a different git branch using
\code{\link[gert:git_branch]{gert::git_branch_checkout()}}, equivalent to \verb{git checkout <branch>} in
the terminal.
}
\examples{
\dontshow{if (rlang::is_installed("gert")) withAutoprint(\{ # examplesIf}
withr::with_tempdir({
  gert::git_init()
  gert::git_config_set("user.name", "R Example")
  gert::git_config_set("user.email", "ex@example.com")

  fs::file_touch("hello.md")

  gert::git_add("hello.md")
  gert::git_commit("Initial commit")

  gert::git_branch_create("feature-1")

  # LLM checks out an existing branch
  res <- btw_tool_git_branch_checkout(branch = "feature-1")

  # What the LLM sees
  cat(res@value)
})
\dontshow{\}) # examplesIf}
}
\seealso{
Other git tools: 
\code{\link{btw_tool_git_branch_create}()},
\code{\link{btw_tool_git_branch_list}()},
\code{\link{btw_tool_git_commit}()},
\code{\link{btw_tool_git_diff}()},
\code{\link{btw_tool_git_log}()},
\code{\link{btw_tool_git_status}()}
}
\concept{git tools}
