% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_bsvar_mix.R
\name{specify_bsvar_mix}
\alias{specify_bsvar_mix}
\title{R6 Class representing the specification of the BSVAR model with a zero-mean mixture of normals model for structural shocks.}
\description{
The class BSVARMIX presents complete specification for the BSVAR model with a zero-mean mixture of normals model for structural shocks.
}
\examples{
data(us_fiscal_lsuw)
spec = specify_bsvar_mix$new(
   data = us_fiscal_lsuw,
   p = 4,
   M = 2
)

}
\seealso{
\code{\link{estimate}}, \code{\link{specify_posterior_bsvar_mix}}
}
\section{Super class}{
\code{bsvars::BSVARMSH} -> \code{BSVARMIX}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{p}}{a non-negative integer specifying the autoregressive lag order of the model.}

\item{\code{identification}}{an object IdentificationBSVARs with the identifying restrictions.}

\item{\code{prior}}{an object PriorBSVARMIX with the prior specification.}

\item{\code{data_matrices}}{an object DataMatricesBSVAR with the data matrices.}

\item{\code{starting_values}}{an object StartingValuesBSVARMIX with the starting values.}

\item{\code{finiteM}}{a logical value - if true a finite mixture model is estimated. Otherwise, a sparse mixture model is estimated in which \code{M=20} and the number of visited states is estimated.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BSVARMIX-new}{\code{specify_bsvar_mix$new()}}
\item \href{#method-BSVARMIX-clone}{\code{specify_bsvar_mix$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bsvars" data-topic="BSVARMSH" data-id="get_data_matrices"><a href='../../bsvars/html/BSVARMSH.html#method-BSVARMSH-get_data_matrices'><code>bsvars::BSVARMSH$get_data_matrices()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bsvars" data-topic="BSVARMSH" data-id="get_identification"><a href='../../bsvars/html/BSVARMSH.html#method-BSVARMSH-get_identification'><code>bsvars::BSVARMSH$get_identification()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bsvars" data-topic="BSVARMSH" data-id="get_prior"><a href='../../bsvars/html/BSVARMSH.html#method-BSVARMSH-get_prior'><code>bsvars::BSVARMSH$get_prior()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bsvars" data-topic="BSVARMSH" data-id="get_starting_values"><a href='../../bsvars/html/BSVARMSH.html#method-BSVARMSH-get_starting_values'><code>bsvars::BSVARMSH$get_starting_values()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVARMIX-new"></a>}}
\if{latex}{\out{\hypertarget{method-BSVARMIX-new}{}}}
\subsection{Method \code{new()}}{
Create a new specification of the BSVAR model with a zero-mean mixture of normals model for structural shocks, BSVARMIX.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvar_mix$new(
  data,
  p = 1L,
  M,
  B,
  stationary = rep(FALSE, ncol(data)),
  finiteM = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{a \code{(T+p)xN} matrix with time series data.}

\item{\code{p}}{a positive integer providing model's autoregressive lag order.}

\item{\code{M}}{an integer greater than 1 - the number of components of the mixture of normals.}

\item{\code{B}}{a logical \code{NxN} matrix containing value \code{TRUE} for the elements of the structural matrix \eqn{B} to be estimated and value \code{FALSE} for exclusion restrictions to be set to zero.}

\item{\code{stationary}}{an \code{N} logical vector - its element set to \code{FALSE} sets the prior mean for the autoregressive parameters of the \code{N}th equation to the white noise process, otherwise to random walk.}

\item{\code{finiteM}}{a logical value - if true a finite mixture model is estimated. Otherwise, a sparse mixture model is estimated in which \code{M=20} and the number of visited states is estimated.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new complete specification for the bsvar model with a zero-mean mixture of normals model for structural shocks, BSVARMIX.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BSVARMIX-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BSVARMIX-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_bsvar_mix$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
