% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify.R
\name{specify_narrative}
\alias{specify_narrative}
\title{vector specifying one narrative restriction}
\usage{
specify_narrative(
  start,
  periods = 1,
  type = "S",
  sign = 1,
  shock = 1,
  var = NA
)
}
\arguments{
\item{start}{positive integer - the period in which the narrative starts (greater than the number of lags).}

\item{periods}{positive integer - the number of periods the narrative restriction lasts.}

\item{type}{character - the type of the narrative restriction (one of "S", "A", "B"), where:
"S" for restrictions on structural shocks;
"A" for type A restrictions on historical decomposition, i.e. if the absolute value of the historical decomposition
of shock to var is the greatest/least among all shocks;
"B" for type B restrictions on historical decomposition, i.e. if the absolute value of the historical decomposition
of shock to var is the greater/less than the sum of all other shocks.}

\item{sign}{integer - the sign of the narrative restriction (1 or -1).}

\item{shock}{positive integer - the index of the shock to which the narrative restriction applies.}

\item{var}{positive integer - the index of the variable to which the narrative restriction applies.}
}
\value{
An object of class \code{narrative} specifying one narrative restriction.
}
\description{
The class narrative specifies a single narrative restriction.
}
\examples{
# specify a narrative restriction
specify_narrative(start = 166, periods = 1, type = "S", sign = 1, shock = 1, var = 6)

}
