% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tooltip.R
\name{tooltip}
\alias{tooltip}
\alias{toggle_tooltip}
\alias{update_tooltip}
\title{Add a tooltip to a UI element}
\usage{
tooltip(
  trigger,
  ...,
  id = NULL,
  placement = c("auto", "top", "right", "bottom", "left"),
  options = list()
)

toggle_tooltip(id, show = NULL, session = get_current_session())

update_tooltip(id, ..., session = get_current_session())
}
\arguments{
\item{trigger}{A UI element (i.e., \link[htmltools:builder]{htmltools tag}) to serve
as the tooltip trigger. If \code{trigger} renders as multiple HTML
elements (e.g., it's a \code{tagList()}), the last HTML element is used for the
trigger. If the \code{trigger} should contain all of those elements, wrap the
object in a \code{\link[=div]{div()}} or \code{\link[=span]{span()}}.}

\item{...}{UI elements for the tooltip. Character strings are \link[=htmlEscape]{automatically escaped} unless marked as \code{\link[=HTML]{HTML()}}.}

\item{id}{a character string that matches an existing tooltip id.}

\item{placement}{The placement of the tooltip relative to its trigger.}

\item{options}{A list of additional \href{https://getbootstrap.com/docs/5.3/components/tooltips/#options}{options}.}

\item{show}{Whether to show (\code{TRUE}) or hide (\code{FALSE}) the tooltip. The
default (\code{NULL}) will show if currently hidden and hide if currently shown.
Note that a tooltip will not be shown if the trigger is not visible (e.g.,
it's hidden behind a tab).}

\item{session}{A Shiny session object (the default should almost always be
used).}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Display additional information when focusing (or hovering over) a UI element.
}
\section{Functions}{
\itemize{
\item \code{tooltip()}: Add a tooltip to a UI element

\item \code{toggle_tooltip()}: Programmatically show/hide a tooltip.

\item \code{update_tooltip()}: Update the contents of a tooltip.

}}
\section{Theming/Styling}{


Like other bslib components, tooltips can be themed by supplying
\href{https://rstudio.github.io/bslib/articles/bs5-variables/index.html#tooltip-bg}{relevant theming variables}
to \code{\link[=bs_theme]{bs_theme()}},
which effects styling of every tooltip on the page.
To style a \emph{specific} tooltip differently from other tooltip, utilize the \code{customClass} option:

\if{html}{\out{<div class="sourceCode">}}\preformatted{tooltip(
  "Trigger", "Tooltip message",
  options = list(customClass = "my-tip")
)
}\if{html}{\out{</div>}}

And then add relevant rules to \code{\link[=bs_theme]{bs_theme()}} via \code{\link[=bs_add_rules]{bs_add_rules()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{bs_theme() |> bs_add_rules(".my-tip \{ max-width: none; \}")
}\if{html}{\out{</div>}}
}

\section{Accessibility of Tooltip Triggers}{


Because the user needs to interact with the \code{trigger} element to see the tooltip, it's best practice to use an element that is typically accessible via keyboard interactions, like a button or a link.
If you use a non-interactive element, like a \verb{<span>} or text, bslib will automatically add the \code{tabindex="0"} attribute to the trigger element to make sure that users can reach the element with the keyboard.
This means that in most cases you can use any element you want as the trigger.

One place where it's important to consider the accessibility of the trigger is when using an icon without any accompanying text.
In these cases, many R packages that provide icons will create an icon element with the assumption that the icon is decorative, which will make it inaccessible to users of assistive technologies.

When using an icon as the primary trigger, ensure that the icon does not have \code{aria-hidden="true"} or \code{role="presentation"} attributes.
Icon packages typically provide a way to specify a title for the icon, as well as a way to specify that the icon is not decorative.
The title should be a short description of the purpose of the trigger, rather than a description of the icon itself.
\itemize{
\item If you're using \code{\link[bsicons:bs_icon]{bsicons::bs_icon()}}, provide a \code{title}.
\item If you're using \code{\link[fontawesome:fa]{fontawesome::fa()}}, set \code{a11y = "sem"} and provide a \code{title}.
}

For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tooltip(
  bsicons::bs_icon("info-circle", title = "About tooltips"),
  "Text shown in the tooltip."
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tooltip(
  fontawesome::fa("info-circle", a11y = "sem", title = "About tooltips"),
  "Text shown in the tooltip."
)
}\if{html}{\out{</div>}}
}

\examples{
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

tooltip(
  shiny::actionButton("btn", "A button"),
  "A message"
)

card(
  card_header(
    tooltip(
      span("Card title ", bsicons::bs_icon("question-circle-fill")),
      "Additional info",
      placement = "right"
    )
  ),
  "Card body content..."
)
\dontshow{\}) # examplesIf}
}
\references{
Tooltips are based on \href{https://getbootstrap.com/docs/5.3/components/tooltips/}{Bootstrap's Tooltip component}. See the
bslib website for an \href{https://rstudio.github.io/bslib/articles/tooltips-popovers/index.html}{interactive introduction to tooltips and popovers}.
}
\seealso{
\code{\link[=popover]{popover()}} provides a an alternative and more persistent container
for additional elements, typically revealed by clicking on a target
element.

Other Components: 
\code{\link{accordion}()},
\code{\link{card}()},
\code{\link{popover}()},
\code{\link{value_box}()}
}
\concept{Components}
