% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo_validation.R
\name{loo_validation.bgmfit}
\alias{loo_validation.bgmfit}
\alias{loo_validation}
\title{Perform leave-one-out (loo) cross-validation}
\usage{
\method{loo_validation}{bgmfit}(
  model,
  compare = TRUE,
  resp = NULL,
  pointwise = FALSE,
  moment_match = FALSE,
  reloo = FALSE,
  k_threshold = 0.7,
  save_psis = FALSE,
  moment_match_args = list(),
  reloo_args = list(),
  model_names = NULL,
  ndraws = NULL,
  draw_ids = NULL,
  cores = 1,
  deriv_model = NULL,
  verbose = FALSE,
  dummy_to_factor = NULL,
  expose_function = FALSE,
  usesavedfuns = NULL,
  clearenvfuns = NULL,
  envir = NULL,
  ...
)

loo_validation(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{compare}{A flag indicating if the information criteria of the models
should be compared to each other via \code{\link[loo:loo_compare]{loo::loo_compare()}}.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{pointwise}{A flag indicating whether to compute the full
log-likelihood matrix at once or separately for each observation.
The latter approach is usually considerably slower but
requires much less working memory. Accordingly, if one runs
into memory issues, \code{pointwise = TRUE} is the way to go.}

\item{moment_match}{A logical argument to indicate whether
\code{\link[loo:loo_moment_match]{loo::loo_moment_match()}} should be applied on problematic observations.
Defaults to \code{FALSE}. For most models, moment matching will only work
if you have set \code{save_pars = save_pars(all = TRUE)} when fitting the
model with \code{\link[brms:brm]{brms::brm()}}. See \code{\link[brms:loo_moment_match.brmsfit]{brms::loo_moment_match()}} for more details.}

\item{reloo}{A logical argument to indicate whether \code{\link[brms:reloo.brmsfit]{brms::reloo()}} should be
applied on problematic observations. Defaults to \code{FALSE}.}

\item{k_threshold}{The threshold at which pareto \eqn{k}
estimates are treated as problematic. Defaults to \code{0.7}.
Only used if argument \code{reloo} is \code{TRUE}.
See \code{\link[loo:pareto-k-diagnostic]{pareto_k_ids}} for more details.}

\item{save_psis}{Should the \code{"psis"} object created internally be saved
in the returned object? For more details see \code{\link[loo:loo]{loo}}.}

\item{moment_match_args}{An optional \code{list} of additional arguments
passed to \code{\link[loo:loo_moment_match]{loo::loo_moment_match()}}.}

\item{reloo_args}{An optional \code{list} of additional arguments passed to
\code{\link[brms:reloo.brmsfit]{brms::reloo()}}.}

\item{model_names}{If \code{NULL} (the default) will use model names
derived from deparsing the call. Otherwise will use the passed
values as model names.}

\item{ndraws}{A positive integer indicating the number of posterior draws to
be used in estimation. If \code{NULL} (default), all draws are used.}

\item{draw_ids}{An integer indicating the specific posterior draw(s)
to be used in estimation (default \code{NULL}).}

\item{cores}{Number of cores to be used when running the parallel
computations (if \code{future = TRUE}). On non-Windows systems this
argument can be set globally via the mc.cores option. For the default
\code{NULL} option, the number of cores are set automatically by calling
the \code{\link[future:re-exports]{future::availableCores()}}. The number of cores used are the maximum
number of cores avaialble minus one, i.e., \code{future::availableCores() -
  1}.}

\item{deriv_model}{A logical to specify whether to estimate velocity curve
from the derivative function, or the differentiation of the distance curve.
The argument \code{deriv_model} is set to \code{TRUE} for those functions
which need velocity curve such as \code{growthparameters()} and
\code{plot_curves()}, and \code{NULL} for functions which explicitly use
the distance curve (i.e., fitted values) such as \code{loo_validation()}
and \code{plot_ppc()}.}

\item{verbose}{An optional argument (logical, default \code{FALSE}) to
indicate whether to print information collected during setting up the
object(s).}

\item{dummy_to_factor}{A named list (default \code{NULL}) that is used to
convert dummy variables into a factor variable. The named elements are
\code{factor.dummy}, \code{factor.name}, and \code{factor.level}. The
\code{factor.dummy} is a vector of character strings that need to be
converted to a factor variable whereas the \code{factor.name} is a single
character string that is used to name the newly created factor variable.
The \code{factor.level} is used to name the levels of newly created factor.
When \code{factor.name} is \code{NULL}, then the factor name is internally
set as \code{'factor.var'}. If \code{factor.level} is \code{NULL}, then
names of factor levels are take from the \code{factor.dummy} i.e., the
factor levels are assigned same name as \code{factor.dummy}. Note that when
\code{factor.level} is not \code{NULL}, its length must be same as the
length of the \code{factor.dummy}.}

\item{expose_function}{An optional logical argument to indicate whether to
expose Stan functions (default \code{FALSE}). Note that if user has already
exposed Stan functions during model fit by setting \code{expose_function =
  TRUE} in the \code{\link[=bsitar]{bsitar()}}, then those exposed functions are saved and can be
used during post processing of the posterior draws and therefore
\code{expose_function} is by default set as \code{FALSE} in all post
processing functions except \code{\link[=optimize_model]{optimize_model()}}. For \code{\link[=optimize_model]{optimize_model()}}, the
default setting is \code{expose_function = NULL}. The reason is that each
optimized model has different Stan function and therefore it need to be re
exposed and saved. The \code{expose_function = NULL} implies that the
setting for \code{expose_function} is taken from the original \code{model}
fit. Note that \code{expose_function} must be set to \code{TRUE} when
adding \code{fit criteria} and/or \code{bayes_R2} during model
optimization.}

\item{usesavedfuns}{A logical (default \code{NULL}) to indicate whether to
use the already exposed and saved \code{Stan} functions. Depending on
whether the user have exposed Stan functions within the \code{\link[=bsitar]{bsitar()}} call via
\code{expose_functions} argument in the \code{\link[=bsitar]{bsitar()}}, the \code{usesavedfuns}
is automatically set to \code{TRUE} (if \code{expose_functions = TRUE}) or
\code{FALSE} (if \code{expose_functions = FALSE}). Therefore, manual
setting of \code{usesavedfuns} as \code{TRUE}/\code{FALSE} is rarely
needed. This is for internal purposes only and mainly used during the
testing of the functions and therefore should not be used by users as it
might lead to unreliable estimates.}

\item{clearenvfuns}{A logical to indicate whether to clear the exposed
function from the environment (\code{TRUE}) or not (\code{FALSE}). If
\code{NULL} (default), then \code{clearenvfuns} is set as \code{TRUE} when
\code{usesavedfuns} is \code{TRUE}, and \code{FALSE} if \code{usesavedfuns}
is \code{FALSE}.}

\item{envir}{Environment used for function evaluation. The default is
\code{NULL} which will set \code{parent.frame()} as default environment.
Note that since most of post processing functions are based on \pkg{brms},
the functions needed for evaluation should be in the \code{.GlobalEnv}.
Therefore, it is strongly recommended to set \code{ envir = globalenv()}
(or \code{envir = .GlobalEnv}). This is particularly true for the
derivatives such as velocity curve.}

\item{...}{Additional arguments passed to the \code{\link[brms:loo.brmsfit]{brms::loo()}} function.
Please see \code{brms::loo} for details on various options available.}
}
\value{
If only one model object is provided, then an object of class
\code{loo} is returned. If multiple objects are provided, an object of
class \code{loolist}.
}
\description{
The \strong{loo_validation()} is a wrapper around the
\code{\link[brms:loo.brmsfit]{brms::loo()}} function to perform approximate leave-one-out
cross-validation based on the posterior likelihood. See \code{\link[brms:loo.brmsfit]{brms::loo()}} for
more details.
}
\details{
See \code{\link[loo:loo_compare]{loo::loo_compare()}} for details on model comparisons. For
\code{bgmfit} objects, \code{LOO} is an alias of \code{loo}. Use method
\code{\link[brms:add_criterion]{brms::add_criterion()}}  to store information criteria in the fitted model
object for later usage.
}
\examples{

# Fit Bayesian SITAR model 

# To avoid mode estimation which takes time, the Bayesian SITAR model fit to 
# the 'berkeley_exdata' has been saved as an example fit ('berkeley_exfit').
# See 'bsitar' function for details on 'berkeley_exdata' and 'berkeley_exfit'.

# Check and confirm whether model fit object 'berkeley_exfit' exists
 berkeley_exfit <- getNsObject(berkeley_exfit)

model <- berkeley_exfit

\donttest{
loo_validation(model, cores = 1)
}


}
\seealso{
\code{\link[brms:loo.brmsfit]{brms::loo()}}
}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
