% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_model.R
\name{update_model.bgmfit}
\alias{update_model.bgmfit}
\alias{update_model}
\title{Update model}
\usage{
\method{update_model}{bgmfit}(model, newdata = NULL, recompile = NULL, verbose = FALSE, ...)

update_model(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{newdata}{An optional \code{data.frame} to be used when updating the
model. If \code{NULL} (default), the data used in the original model fit is
re used. Note that data-dependent default priors are not updated
automatically.}

\item{recompile}{A logical to indicate whether the Stan model should be
recompiled. When \code{NULL} (default), \strong{update_model()} tries to
figure out internally whether recompilation is required or not. Setting
\code{recompile} to \code{FALSE} will ignore Stan code changing arguments.}

\item{verbose}{An optional argument (logical, default \code{FALSE}) to
indicate whether to print information collected during setting up the
object(s).}

\item{...}{Other arguments passed to \code{\link{brms}}.}
}
\value{
An updated object of class \code{brmsfit}.
}
\description{
The \strong{update_model()} is a wrapper around the
\code{update()} function in the \pkg{brms} package which refits the model
as per the user specified updated arguments.
}
\details{
This is an adapted version of the \strong{update()} function from
available the the\pkg{brms} package.
}
\examples{

\donttest{

# Fit Bayesian SITAR model 

# To avoid mode estimation which takes time, a model fitted to the 
# 'berkeley_mdata' has already been saved as 'berkeley_mfit'. 
# Details on 'berkeley_mdata' and 'berkeley_mfit' are provided in the 
# 'bsitar' function.

model <- berkeley_mfit

# Update model for degree of freedom. For illustration purpose, and to save 
# time, the below example is run with sample_prior only. 

model2 <- update_model(model, df = 5, sample_prior = 'only')

}

}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
