% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_conditional_effects.R
\name{plot_conditional_effects.bgmfit}
\alias{plot_conditional_effects.bgmfit}
\alias{plot_conditional_effects}
\title{Visualize conditional effects of predictor}
\usage{
\method{plot_conditional_effects}{bgmfit}(
  model,
  resp = NULL,
  deriv = 0,
  deriv_model = TRUE,
  usesavedfuns = FALSE,
  clearenvfuns = FALSE,
  envir = NULL,
  ...
)

plot_conditional_effects(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}. function.}

\item{resp}{A character string to specify response variable when processing
posterior draws for the univariate-by-subgroup and multivariate models (see
\code{\link[=bsitar]{bsitar()}} for details on fitting univariate-by-subgroup and
multivariate models). For univariate model, \code{resp = NULL} (default).
Note that argument \code{resp} must be specified for the
univariate-by-subgroup and multivariate models otherwise it will result in
an error. On the other hand, argument \code{resp} must be \code{NULL} for
the univariate model. The default setting is \code{resp = NULL} assuming a
univariate model.}

\item{deriv}{An integer to indicate whether to estimate distance curve or
derivatives (velocity and acceleration curves). Default \code{deriv = 0} is
for the distance curve, \code{deriv = 1} for velocity curve, and
\code{deriv = 2} for the acceleration curve.}

\item{deriv_model}{A logical (default \code{TRUE}) to indicate whether to
estimate model based derivatives or from the differentiation of the
distance curve. When model is fit with \code{decomp = 'QR'}, the only
approach available to estimate derivatives by the  differentiation of the
distance curve.}

\item{usesavedfuns}{A logical (default \code{FALSE}) to indicate whether to
use the already exposed and saved \code{Stan} functions. This is for
internal use when testing the function and not used routinely.}

\item{clearenvfuns}{A logical (default \code{FALSE}) to indicate whether to
clear the exposed function from the environment.}

\item{envir}{Environment of function evaluation. The default is \code{NULL}
which will set \code{parent.frame()} as default environment. Note that
since most of post processing functions are based on \pkg{brms}, it is
strongly advised to set \code{globalenv()} (or \code{.GlobalEnv}) as
environment. This is particularly true for derivatives such as velocity
curve.}

\item{...}{Additional arguments passed to the \code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}}
function. Please see \code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}} for details.}
}
\value{
An object of class 'brms_conditional_effects' which is a named list
with one data.frame per effect containing all information required to
generate conditional effects plots. See brms::conditional_effects for
details.
}
\description{
Display conditional effects of one or more numeric and/or categorical
predictors including two-way interaction effects.
}
\details{
The \strong{plot_conditional_effects()} is a wrapper around the
\code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}}. The \code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}} function
from the \pkg{brms} package can used to plot the fitted (distance) curve
when response (e.g., height) is not transformed. However, when the outcome
is log or square root transformed, the \code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}} will
return the fitted curve on the log or square root scale whereas the
\strong{plot_conditional_effects()} will return the fitted curve on the
original scale. Furthermore, the \strong{plot_conditional_effects()} also
plots the velocity curve on the original scale after making required
back-transformation. Apart from these differences, both these functions
(\link[brms:conditional_effects.brmsfit]{brms::conditional_effects} and \strong{plot_conditional_effects()} work
in the same manner. In other words, user can specify all the arguments
which are available in the \code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}}.
}
\examples{

# Fit Bayesian SITAR model 

# To avoid fitting the model which takes time, the model  
# fit has already been saved as 'berkeley_mfit.rda' file.
# See examples section of the main function for details on the model fit.

model <- berkeley_mfit

# Population average distance curve
plot_conditional_effects(model, deriv = 0, re_formula = NA)

\donttest{
# Individual-specific distance curves
plot_conditional_effects(model, deriv = 0, re_formula = NULL)

# Population average velocity curve
plot_conditional_effects(model, deriv = 1, re_formula = NA)

# Individual-specific velocity curves
plot_conditional_effects(model, deriv = 1, re_formula = NULL)
}

}
\seealso{
\code{\link[brms:conditional_effects.brmsfit]{brms::conditional_effects()}}
}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
