% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboardHeader.R
\name{navbarTab}
\alias{navbarTab}
\alias{navbarMenu}
\alias{updateNavbarTabs}
\title{Navbar tab item}
\usage{
navbarTab(text, ..., tabName = NULL, icon = NULL, .list = NULL)

navbarMenu(..., id = NULL)

updateNavbarTabs(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  selected = NULL
)
}
\arguments{
\item{text}{Tab text.}

\item{...}{Slot for \link{navbarTab}.}

\item{tabName}{Should correspond exactly to the tabName given in \link{tabItem}.}

\item{icon}{An icon tag, created by shiny::icon. If NULL, don't display an icon.}

\item{.list}{Use this slot if you had to programmatically pass \link{navbarTab}
like with \link{lapply}.}

\item{id}{Menu id. Useful to leverage \link{updateNavbarTabs} on the
server.}

\item{session}{Shiny session object.}

\item{inputId}{The id of the \code{tabsetPanel}, \code{navlistPanel},
or \code{navbarPage} object.}

\item{selected}{If \code{TRUE}, this \code{menuSubItem}
will start selected. If no item have \code{selected=TRUE}.}
}
\description{
Similar to \link{menuItem} but for the
\link{dashboardHeader}.

Like \link{sidebarMenu} but inside \link{dashboardHeader}.
}
\note{
You can nest \link{navbarTab} so it does like
\link{menuSubItem}. This is to avoid to create too many functions.
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 
 tabs <- tabItems(.list = lapply(1:7, function(i) {
  tabItem(tabName = sprintf("Tab\%s", i), sprintf("Tab \%s", i))
 }))
 
 shinyApp(
   ui = dashboardPage(
     header = dashboardHeader(
       navbarMenu(
         id = "navmenu",
         navbarTab(tabName = "Tab1", text = "Tab 1"),
         navbarTab(tabName = "Tab2", text = "Tab 2"),
         navbarTab(
           text = "Menu",
           dropdownHeader("Dropdown header"),
           navbarTab(tabName = "Tab3", text = "Tab 3"),
           dropdownDivider(),
           navbarTab(
             text = "Sub menu",
             dropdownHeader("Another header"),
             navbarTab(tabName = "Tab4", text = "Tab 4"),
             dropdownHeader("Yet another header"),
             navbarTab(tabName = "Tab5", text = "Tab 5"),
             navbarTab(
               text = "Sub sub menu",
               navbarTab(tabName = "Tab6", text = "Tab 6"),
               navbarTab(tabName = "Tab7", text = "Tab 7")
             )
           )
         )
       )
     ),
     body = dashboardBody(tabs),
     controlbar = dashboardControlbar(
       sliderInput(
         inputId = "controller",
         label = "Update the first tabset",
         min = 1,
         max = 4,
         value = 1
       )
     ),
     sidebar = dashboardSidebar(disable = TRUE)
   ),
   server = function(input, output, session) {
     observeEvent(input$controller, {
       updateNavbarTabs(
         session,
         inputId = "navmenu",
         selected = paste0("Tab", input$controller)
       )
     },
     ignoreInit = TRUE
     )
   }
 )
}
}
