% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feedbacks.R
\name{popover}
\alias{popover}
\alias{addPopover}
\alias{removePopover}
\title{Create a Bootstrap 4 popover from the UI side}
\usage{
popover(tag, content, title, placement = c("top", "bottom", "left", "right"))

addPopover(
  id = NULL,
  selector = NULL,
  options,
  session = shiny::getDefaultReactiveDomain()
)

removePopover(id, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{tag}{Popover target.}

\item{content}{Popover content.}

\item{title}{Popover title.}

\item{placement}{Popover placement: "top", "bottom", "left" or "right".}

\item{id}{Popover target id.}

\item{selector}{jQuery selector. Allow more customization for the target (nested tags).}

\item{options}{List of options to pass to the popover. See \url{https://getbootstrap.com/docs/4.0/components/popovers/}.}

\item{session}{Shiny session object.}
}
\description{
This replaces the shinyBS popover feature that is not compatible
with Bootstrap 4

\link{addPopover} adds a popover to the given target.

\link{removePopover} destroys the current targeted popover.
}
\note{
\link{popover} does not automatically handles tooltip removal and must be seperately implemented.
If the \link{dashboardHeader} help parameter is TRUE, all popovers may be enabled
or disabled depending on the switch value, which may solve this problem.
This allows to toggle popovers whenever required.

This replaces the shinyBS popover feature that is not compatible
with Bootstrap 4
}
\examples{
if (interactive()) {
  library(shiny)
  library(bs4Dash)

  shinyApp(
    ui = dashboardPage(
      header = dashboardHeader(),
      sidebar = dashboardSidebar(),
      controlbar = dashboardControlbar(),
      footer = dashboardFooter(),
      title = "Popover UI",
      body = dashboardBody(
        popover(
          actionButton("goButton", "Click me to see the popover!"),
          title = "My popover",
          placement = "right",
          content = "Vivamus sagittis lacus vel augue laoreet rutrum faucibus."
        )
      )
    ),
    server = function(input, output) {}
  )
}
if (interactive()) {
  library(shiny)
  library(bs4Dash)

  shinyApp(
    ui = dashboardPage(
      header = dashboardHeader(),
      sidebar = dashboardSidebar(),
      controlbar = dashboardControlbar(),
      footer = dashboardFooter(),
      title = "Popover server",
      body = dashboardBody(
        sliderInput("obs", "Number of observations:",
          min = 0, max = 1000, value = 500
        ),
        plotOutput("distPlot")
      )
    ),
    server = function(input, output, session) {
      output$distPlot <- renderPlot({
        hist(rnorm(input$obs))
      })

      observeEvent(input$obs, {
        if (input$obs > 500) {
          addPopover(
            id = "distPlot",
            options = list(
              content = "Vivamus sagittis lacus vel augue laoreet rutrum faucibus.",
              title = "Server popover",
              placement = "bottom",
              trigger = "hover"
            )
          )
        } else {
          removePopover(id = "distPlot")
        }
      })
    }
  )
}
}
