% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{userMessages}
\alias{userMessages}
\alias{userMessage}
\alias{updateUserMessages}
\title{AdminLTE3 user message container}
\usage{
userMessages(..., id = NULL, status, width = 4, height = NULL)

userMessage(
  ...,
  author = NULL,
  date = NULL,
  image = NULL,
  type = c("sent", "received")
)

updateUserMessages(
  id,
  action = c("add", "remove", "update"),
  index = NULL,
  content = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{...}{Message text.}

\item{id}{\link{userMessages} to target.}

\item{status}{Messages status. Valid colors are defined as follows:
\itemize{
  \item \code{primary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#007bff")}.
  \item \code{secondary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6c757d")}.
  \item \code{info}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#17a2b8")}.
  \item \code{success}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#28a745")}.
  \item \code{warning}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ffc107")}.
  \item \code{danger}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#dc3545")}.
  \item \code{gray-dark}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#343a40")}.
  \item \code{gray}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#adb5bd")}.
  \item \code{white}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#fff")}.
  \item \code{indigo}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6610f2")}.
  \item \code{lightblue}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3c8dbc")}.
  \item \code{navy}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#001f3f")}.
  \item \code{purple}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#605ca8")}.
  \item \code{fuchsia}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#f012be")}.
  \item \code{pink}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#e83e8c")}.
  \item \code{maroon}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#d81b60")}.
  \item \code{orange}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ff851b")}.
  \item \code{lime}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#01ff70")}.
  \item \code{teal}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#39cccc")}.
  \item \code{olive}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3d9970")}.
}}

\item{width}{Container width: between 1 and 12.}

\item{height}{Container height.}

\item{author}{Message author.}

\item{date}{Message date.}

\item{image}{Message author image path or url.}

\item{type}{Message type: \code{c("sent", "received")}.}

\item{action}{Action to perform: add, remove or update.}

\item{index}{Index of item to update or remove.}

\item{content}{New message content in a list. For actions like add and update only! See example.}

\item{session}{Shiny session object.}
}
\description{
\link{userMessages} creates a user message container. Maybe inserted in a \link{box}.

\link{userMessage} creates a user message html element.

\link{updateUserMessages} allows to interact with a \link{userMessages} container,
such as sending, removing or editing messages.
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     box(
      title = "Box with messages",
      solidHeader = TRUE,
      status = "warning",
      userMessages(
       width = 12,
       status = "teal",
       userMessage(
         author = "Alexander Pierce",
         date = "20 Jan 2:00 pm",
         image = "https://adminlte.io/themes/AdminLTE/dist/img/user1-128x128.jpg",
         type = "sent",
         "Is this template really for free? That's unbelievable!"
       ),
       userMessage(
         author = "Sarah Bullock",
         date = "23 Jan 2:05 pm",
         image = "https://adminlte.io/themes/AdminLTE/dist/img/user3-128x128.jpg",
         type = "received",
         "You better believe it!"
       )
      )
     ),
     userMessages(
       width = 6,
       status = "danger",
        userMessage(
         author = "Alexander Pierce",
         date = "20 Jan 2:00 pm",
         image = "https://adminlte.io/themes/AdminLTE/dist/img/user1-128x128.jpg",
         type = "received",
         "Is this template really for free? That's unbelievable!"
       ),
       userMessage(
         author = "Sarah Bullock",
         date = "23 Jan 2:05 pm",
         image = "https://adminlte.io/themes/AdminLTE/dist/img/user3-128x128.jpg",
         type = "sent",
         "You better believe it!"
       )
      )
    ),
    title = "user Message"
  ),
  server = function(input, output) { }
 )
}

if (interactive()) {
 library(shiny)
 library(bs4Dash)
 
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
      fluidRow(
        actionButton("remove", "Remove message"),
        actionButton("add", "Add message"),
        actionButton("update", "Update message")
      ),
      numericInput("index", "Message index:", 1, min = 1, max = 3),
      br(),
      br(),
      userMessages(
        width = 6,
        status = "danger",
        id = "message",
        userMessage(
          author = "Alexander Pierce",
          date = "20 Jan 2:00 pm",
          image = "https://adminlte.io/themes/AdminLTE/dist/img/user1-128x128.jpg",
          type = "received",
          "Is this template really for free? That's unbelievable!"
        ),
        userMessage(
          author = "Sarah Bullock",
          date = "23 Jan 2:05 pm",
          image = "https://adminlte.io/themes/AdminLTE/dist/img/user3-128x128.jpg",
          type = "sent",
          "You better believe it!"
        )
      )
    ),
    title = "user Message"
  ),
  server = function(input, output, session) {
    observeEvent(input$remove, {
      updateUserMessages("message", action = "remove", index = input$index)
    })
    observeEvent(input$add, {
      updateUserMessages(
        "message", 
        action = "add", 
        content = list(
          author = "David",
          date = "Now",
          image = "https://i.pinimg.com/originals/f1/15/df/f115dfc9cab063597b1221d015996b39.jpg",
          type = "received",
          text = tagList(
           sliderInput(
            "obs", 
            "Number of observations:",
            min = 0, 
            max = 1000, 
            value = 500
           ),
           plotOutput("distPlot")
          )
        )
      )
    })
    
    output$distPlot <- renderPlot({
     hist(rnorm(input$obs))
    })
    
    observeEvent(input$update, {
      updateUserMessages(
        "message", 
        action = "update", 
        index = input$index,
        content = list(
         text = tagList(
          appButton(
           inputId = "reload",
           label = "Click me!", 
           icon = icon("sync"), 
           dashboardBadge(1, color = "orange")
          )
         )
        )
      )
    })
    
    observeEvent(input$reload, {
     showNotification("Yeah!", duration = 1, type = "default")
    })
  }
 )
}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
