% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR-stats_2_scale.R
\name{\%\%COMPUTE\%\%}
\alias{\%\%COMPUTE\%\%}
\alias{COUNT}
\alias{MODE}
\alias{SUM}
\alias{.sum}
\alias{MEAN}
\alias{.mean}
\alias{STD}
\alias{CONSEC}
\title{Multivariate computation.}
\usage{
COUNT(data, var = NULL, items = NULL, vars = NULL, varrange = NULL, value = NA)

MODE(data, var = NULL, items = NULL, vars = NULL, varrange = NULL)

SUM(
  data,
  var = NULL,
  items = NULL,
  vars = NULL,
  varrange = NULL,
  rev = NULL,
  range = likert,
  likert = NULL,
  na.rm = TRUE
)

.sum(
  var = NULL,
  items = NULL,
  vars = NULL,
  varrange = NULL,
  rev = NULL,
  range = likert,
  likert = NULL,
  na.rm = TRUE
)

MEAN(
  data,
  var = NULL,
  items = NULL,
  vars = NULL,
  varrange = NULL,
  rev = NULL,
  range = likert,
  likert = NULL,
  na.rm = TRUE
)

.mean(
  var = NULL,
  items = NULL,
  vars = NULL,
  varrange = NULL,
  rev = NULL,
  range = likert,
  likert = NULL,
  na.rm = TRUE
)

STD(
  data,
  var = NULL,
  items = NULL,
  vars = NULL,
  varrange = NULL,
  rev = NULL,
  range = likert,
  likert = NULL,
  na.rm = TRUE
)

CONSEC(
  data,
  var = NULL,
  items = NULL,
  vars = NULL,
  varrange = NULL,
  values = 0:9
)
}
\arguments{
\item{data}{Data frame.}

\item{var}{\strong{[Option 1]}
Common part across variables: e.g., \code{"RSES"}, \code{"XX.{i}.pre"}
(if \code{var} string has any placeholder in braces \code{{...}},
then \code{items} will be pasted into the braces, see examples)}

\item{items}{\strong{[Option 1]}
Unique part across variables: e.g., \code{1:10}, \code{c("a", "b", "c")}}

\item{vars}{\strong{[Option 2]}
Character vector specifying variables: e.g., \code{c("X1", "X2", "X3", "X4", "X5")}}

\item{varrange}{\strong{[Option 3]}
Character string specifying positions ("start:stop") of variables: e.g., \code{"A1:E5"}}

\item{value}{[Only for \code{COUNT}] The value to be counted.}

\item{rev}{[Optional] Variables that need to be reversed. It can be
(1) a character vector specifying the reverse-scoring variables (recommended), or
(2) a numeric vector specifying the item number of reverse-scoring variables (not recommended).}

\item{range, likert}{[Optional] Range of likert scale: e.g., \code{1:5}, \code{c(1, 5)}.
If not provided, it will be automatically estimated from the given data (BUT you should use this carefully).}

\item{na.rm}{Ignore missing values. Defaults to \code{TRUE}.}

\item{values}{[Only for \code{CONSEC}] Values to be counted as consecutive identical values. Defaults to all numbers (\code{0:9}).}
}
\value{
A vector of computed values.
}
\description{
Easily compute multivariate sum, mean, and other scores.
Reverse scoring can also be easily implemented without saving extra variables.
\code{\link{Alpha}} function uses a similar method to deal with reverse scoring.

Three ways to specify variables:
\enumerate{
  \item \strong{\code{var + items}}: common and unique parts of variable names (suggested).
  \item \strong{\code{vars}}: a character vector of variable names (suggested).
  \item \strong{\code{varrange}}: starting and stopping positions of variables (NOT suggested).
}
}
\section{Functions}{
\itemize{
\item \code{COUNT()}: \strong{Count} a certain value across variables.

\item \code{MODE()}: Compute \strong{mode} across variables.

\item \code{SUM()}: Compute \strong{sum} across variables.

\item \code{.sum()}: Tidy version of \code{SUM},
only can be used in \code{\link[bruceR:add]{add()/added()}}

\item \code{MEAN()}: Compute \strong{mean} across variables.

\item \code{.mean()}: Tidy version of \code{MEAN},
only can be used in \code{\link[bruceR:add]{add()/added()}}

\item \code{STD()}: Compute \strong{standard deviation} across variables.

\item \code{CONSEC()}: Compute \strong{consecutive identical digits} across variables (especially useful in detecting careless responding).

}}
\examples{
d = data.table(
  x1 = 1:5,
  x4 = c(2,2,5,4,5),
  x3 = c(3,2,NA,NA,5),
  x2 = c(4,4,NA,2,5),
  x5 = c(5,4,1,4,5)
)
d
## I deliberately set this order to show you
## the difference between "vars" and "varrange".

## ====== Usage 1: data.table `:=` ====== ##
d[, `:=`(
  na = COUNT(d, "x", 1:5, value=NA),
  n.2 = COUNT(d, "x", 1:5, value=2),
  sum = SUM(d, "x", 1:5),
  m1 = MEAN(d, "x", 1:5),
  m2 = MEAN(d, vars=c("x1", "x4")),
  m3 = MEAN(d, varrange="x1:x2", rev="x2", range=1:5),
  cons1 = CONSEC(d, "x", 1:5),
  cons2 = CONSEC(d, varrange="x1:x5")
)]
d

## ====== Usage 2: `add()` & `added()` ====== ##
data = as.data.table(psych::bfi)
added(data, {
  gender = as.factor(gender)
  education = as.factor(education)
  E = .mean("E", 1:5, rev=c(1,2), range=1:6)
  A = .mean("A", 1:5, rev=1, range=1:6)
  C = .mean("C", 1:5, rev=c(4,5), range=1:6)
  N = .mean("N", 1:5, range=1:6)
  O = .mean("O", 1:5, rev=c(2,5), range=1:6)
}, drop=TRUE)
data

## ====== New Feature for `var` & `items` ====== ##
d = data.table(
  XX.1.pre = 1:5,
  XX.2.pre = 6:10,
  XX.3.pre = 11:15
)
add(d, { XX.mean = .mean("XX.{i}.pre", 1:3) })
add(d, { XX.mean = .mean("XX.{items}.pre", 1:3) })  # the same
add(d, { XX.mean = .mean("XX.{#$\%^&}.pre", 1:3) })  # the same

}
