% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_stats_04_regress.R
\name{model_summary}
\alias{model_summary}
\title{Tidy report of regression models (into R console, Word, or HTML).}
\usage{
model_summary(
  model_list,
  std_coef = FALSE,
  digits = nsmall,
  nsmall = 3,
  zero = ifelse(std_coef, FALSE, TRUE),
  modify_se = NULL,
  bold = 0,
  file = NULL,
  ...
)
}
\arguments{
\item{model_list}{A single model or a list of models. The models should be of the same type.}

\item{std_coef}{Standardized coefficients? Default is \code{FALSE}.
Only applicable to linear models and linear mixed models.
Not applicable to generalized linear (mixed) models.}

\item{digits}{Number of decimal places of output. Default is \code{3}.}

\item{nsmall}{The same as \code{digits}.}

\item{zero}{Display "0" before "."? Default is \code{TRUE}.}

\item{modify_se}{Set custom values for standard errors.
Useful if you need to replace raw SEs with robust SEs.
New SEs should be provided as a list of numeric vectors.
See usage in \code{\link[texreg:screenreg]{texreg::screenreg()}}.}

\item{bold}{The p-value threshold below which the coefficient shall be formatted in a bold font.
For example, \code{bold = 0.05} will cause all coefficients that are significant at the 95\% level to be formatted in bold.}

\item{file}{File name of the Word or HTML document.
The extension should be \code{.doc} or \code{.html}.}

\item{...}{Other parameters passed to the
\code{\link[texreg:screenreg]{texreg::screenreg()}} or
\code{\link[texreg:htmlreg]{texreg::htmlreg()}} function.}
}
\value{
Invisibly return the plain text of output.
}
\description{
This function is an extension (and combination) of
\code{\link[texreg:screenreg]{texreg::screenreg()}},
\code{\link[texreg:htmlreg]{texreg::htmlreg()}},
\code{\link[MuMIn:std.coef]{MuMIn::std.coef()}}, and
\code{\link[MuMIn:r.squaredGLMM]{MuMIn::r.squaredGLMM()}}.
}
\examples{
\donttest{## Example 1: Linear Model
lm1=lm(Temp ~ Month + Day, data=airquality)
lm2=lm(Temp ~ Month + Day + Wind + Solar.R, data=airquality)
model_summary(lm1)
model_summary(lm2)
model_summary(list(lm1, lm2))
model_summary(list(lm1, lm2), std=TRUE, digits=2)
model_summary(list(lm1, lm2), file="OLS Models.doc")
model_summary(list(lm1, lm2), file="OLS Models.html")
unlink("OLS Models.doc")  # delete file for test
unlink("OLS Models.html")  # delete file for test

## Example 2: Generalized Linear Model
glm1=glm(case ~ age + parity,
         data=infert, family=binomial)
glm2=glm(case ~ age + parity + education + spontaneous + induced,
         data=infert, family=binomial)
model_summary(list(glm1, glm2))  # "std_coef" is not applicable to glm
model_summary(list(glm1, glm2), file="GLM Models.doc")
unlink("GLM Models.doc")  # delete file for test

## Example 3: Linear Mixed Model
library(lmerTest)
hlm1=lmer(Reaction ~ (1 | Subject), data=sleepstudy)
hlm2=lmer(Reaction ~ Days + (1 | Subject), data=sleepstudy)
hlm3=lmer(Reaction ~ Days + (Days | Subject), data=sleepstudy)
model_summary(list(hlm1, hlm2, hlm3))
model_summary(list(hlm1, hlm2, hlm3), std=TRUE)
model_summary(list(hlm1, hlm2, hlm3), file="HLM Models.doc")
unlink("HLM Models.doc")  # delete file for test

## Example 4: Generalized Linear Mixed Model
library(lmerTest)
data.glmm=MASS::bacteria
glmm1=glmer(y ~ trt + week + (1 | ID), data=data.glmm, family=binomial)
glmm2=glmer(y ~ trt + week + hilo + (1 | ID), data=data.glmm, family=binomial)
model_summary(list(glmm1, glmm2))  # "std_coef" is not applicable to glmm
model_summary(list(glmm1, glmm2), file="GLMM Models.doc")
unlink("GLMM Models.doc")  # delete file for test

## Example 5: Multinomial Logistic Model
library(nnet)
d=airquality
d$Month=as.factor(d$Month)  # Factor levels: 5, 6, 7, 8, 9
mn1=multinom(Month ~ Temp, data=d, Hess=TRUE)
mn2=multinom(Month ~ Temp + Wind + Ozone, data=d, Hess=TRUE)
model_summary(mn1)
model_summary(mn2)
model_summary(mn2, file="Multinomial Logistic Model.doc")
unlink("Multinomial Logistic Model.doc")  # delete file for test
}

}
