% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_stats_02_scale.R
\name{EFA}
\alias{EFA}
\title{Exploratory factor analysis (EFA).}
\usage{
EFA(
  data,
  vartext,
  method = "eigen",
  extraction = "pa",
  rotation = "varimax",
  nFactors = 1,
  hideLoadings = 0.3
)
}
\arguments{
\item{data}{Data frame.}

\item{vartext}{Character string specifying the model (e.g., \code{"X[1:5] + Y[c(1,3)] + Z"}).}

\item{method}{\code{"eigen"} (default), \code{"parallel"}, or \code{"fixed"}, the way to determine the number of factors.}

\item{extraction}{\code{"pa"} (default), \code{"ml"}, or \code{"minres"},
using "principal axis", "maximum likelihood", or "minimum residual" as the factor extraction method, respectively.}

\item{rotation}{\code{"varimax"} (default), \code{"oblimin"}, or \code{"none"}, the rotation method.}

\item{nFactors}{An integer (default is 1) fixing the number of factors.
Only relevant when \code{method="fixed"}.}

\item{hideLoadings}{A number (0~1, default is 0.3) for hiding factor loadings below this value.}
}
\value{
No return value.
}
\description{
An extension of \code{jmv::\link[jmv]{efa}}.
}
\note{
It does not have the extraction method "Principal Components". You may still use SPSS.
}
\examples{
\donttest{EFA(bfi, "E[1:5] + A[1:5] + C[1:5] + N[1:5] + O[1:5]", method="fixed", nFactors=5)
}
}
\seealso{
\code{jmv::\link[jmv]{efa}}
}
