% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_easystats.R
\name{tidy_parameters}
\alias{tidy_parameters}
\title{Tidy dataframes of model parameters using \code{broom} and \code{easystats}.}
\usage{
tidy_parameters(x, conf.int = TRUE, ...)
}
\arguments{
\item{x}{An object to be converted into a tidy \code{\link[tibble:tibble]{tibble::tibble()}}.}

\item{conf.int}{Indicating whether or not to include a confidence interval in
the tidied output.}

\item{...}{Additional arguments that will be passed to
\code{\link[parameters:model_parameters]{parameters::model_parameters()}} and \code{\link[broom:reexports]{broom::tidy()}}.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Computes parameters for regression models.
}
\details{
The function will attempt to get these details first using
\code{\link[parameters:model_parameters]{parameters::model_parameters()}} and then using \code{\link[broom:reexports]{broom::tidy()}}.
}
\examples{
set.seed(123)
mod <- lm(mpg ~ wt + cyl, data = mtcars)
broomExtra::tidy_parameters(mod)
}
