% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_trajectory}
\alias{plot_trajectory}
\title{Plot observed and fitted trajectories from fitted brokenstick model}
\usage{
plot_trajectory(
  x,
  data,
  color_y = c(grDevices::hcl(240, 100, 40, 0.7), grDevices::hcl(240, 100, 40, 0.8)),
  size_y = 2,
  color_yhat = c(grDevices::hcl(0, 100, 40, 0.7), grDevices::hcl(0, 100, 40, 0.8)),
  size_yhat = 2,
  color_imp = c("grey80", "grey80"),
  size_imp = 2,
  ncol = 3L,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  scales = "fixed",
  theme = ggplot2::theme_light()
)
}
\arguments{
\item{x}{An object of class \code{brokenstick}.}

\item{data}{A \code{data.frame} with columns names \code{x$names}, \code{".source"}
and \code{".pred"}, and possibly \code{".imp"}}

\item{color_y}{A character vector with two elements specifying the symbol and line color of the measured data points}

\item{size_y}{Dot size of measured data points}

\item{color_yhat}{A character vector with two elements specifying the symbol and line color of the predicted data points}

\item{size_yhat}{Dot size of predicted data points}

\item{color_imp}{A character vector with two elements specifying the symbol and line color of the imputed data}

\item{size_imp}{Dot size of imputed data}

\item{ncol}{Number of columns in plot}

\item{xlab}{The label of the x-axis}

\item{ylab}{The label of the y-axis}

\item{xlim}{Vector of length 2 with range of x-axis}

\item{ylim}{Vector of length 2 with range of y-axis}

\item{scales}{Axis scaling, e.g. \code{"fixed"}, \code{"free"}, and so on}

\item{theme}{Plotting theme}
}
\value{
An object of class \code{ggplot}
}
\description{
This function is called by \code{plot.brokenstick}. Normally we wouldn't
call \code{plot_trajectory()} directly.
}
\seealso{
\link{plot.brokenstick}
}
