#' Set controls to steer calculations
#'
#' @param lmer A list generated by [lme4::lmerControl]. The default
#' is set to `lmerControl(check.nobs.vs.nRE = "warning")`, which turn
#' fatal errors with respect the number of parameters into warnings. Use
#' `lmerControl(check.nobs.vs.nRE = "ignore")` to silence `lmer()`.
#' @param kr A list generated by [control_kr].
#' @param na.action The function to call for the `na.action` argument.
#' The default is `na.exclude`.
#'
#' @export
control_brokenstick <- function(
  lmer = lmerControl(check.nobs.vs.nRE = "warning"),
  kr = control_kr(),
  na.action = na.exclude) {
  list(lmer = lmer,
       kr = kr,
       na.action = na.action)
}

#' Set controls for Kasim-Raudenbush sampler
#'
#' @param model Correlation model: `argyle` (default), `cole` or `none`
#' @param runin Number of run-in iterations
#' @param ndraw Number of parameter draws
#' @param par_skip Number of iterations to next parameter draw
#' @param imp_skip Number of iterations to next outcome draw
#' @return A list with five components
#'
#' @export
control_kr <- function(
  model = c("argyle", "cole", "none"),
  runin = 100L,
  ndraw = 200L,
  par_skip = 1L,
  imp_skip = Inf) {

  model <- match.arg(model)
  list(
    model = model,
    runin = runin,
    ndraw = ndraw,
    par_skip = par_skip,
    imp_skip = imp_skip
  )
}
