% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc_rel.R
\name{bc.rel}
\alias{bc.rel}
\alias{bc.rel,ANY-method}
\title{Broadcasted General Relational Operators}
\usage{
bc.rel(x, y, op, ...)

\S4method{bc.rel}{ANY}(x, y, op)
}
\arguments{
\item{x, y}{conformable arrays of any atomic type.}

\item{op}{a single string, giving the relational operator. \cr
Supported relational operators: ==, !=, <, >, <=, >=.}

\item{...}{further arguments passed to or from methods. \cr \cr}
}
\value{
A logical array as a result of the broadcasted general relational operation. \cr \cr
}
\description{
The \code{bc.rel()} function
performs broadcasted general relational operations on 2 arrays. \cr
}
\examples{

x.dim <- c(4:2)
x.len <- prod(x.dim)
x.data <- sample(c(NA, 1.1:1000.1), x.len, TRUE)
x <- array(x.data, x.dim)
y <- array(1:50, c(4,1,1))


bc.rel(x, y, "==")
bc.rel(x, y, "!=")
bc.rel(x, y, "<")
bc.rel(x, y, ">")
bc.rel(x, y, "<=")
bc.rel(x, y, ">=")
}
\seealso{
\link{broadcast_operators} \cr
}
