% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc_i.R
\name{bc.i}
\alias{bc.i}
\alias{bc.i,ANY-method}
\title{Broadcasted Integer Numeric Operations with Extra Overflow Protection}
\usage{
bc.i(x, y, op, ...)

\S4method{bc.i}{ANY}(x, y, op)
}
\arguments{
\item{x, y}{conformable logical or numeric arrays.}

\item{op}{a single string, giving the operator. \cr
Supported arithmetic operators: +, -, *, gcd, \%\%, \%/\%, ^, pmin, pmax. \cr
Supported relational operators: ==, !=, <, >, <=, >=. \cr
The "gcd" operator performs the Greatest Common Divisor" operation,
using the Euclidean algorithm.}

\item{...}{further arguments passed to or from methods. \cr \cr}
}
\value{
For arithmetic operators: \cr
A numeric array of whole numbers,
as a result of the broadcasted arithmetic operation. \cr
Base 'R' supports integers from \code{-2^53} to \code{2^53},
which thus range from approximately \code{-9} quadrillion to \code{+9} quadrillion. \cr
Values outside of this range will be returned as \code{-Inf} or \code{Inf},
as an extra protection against integer overflow. \cr
\cr
For relational operators: \cr
A logical array as a result of the broadcasted integer relational comparison. \cr
\cr
}
\description{
The \code{bc.i()} function
performs broadcasted integer numeric operations on 2 numeric or logical arrays. \cr
\cr
Please note that these operations will treat the input as (\code{double} typed) integers,
and will efficiently truncate when necessary. \cr
Therefore, something like \code{bc.i(1, 1.5, "==")} returns \code{TRUE},
because \code{trunc(1.5)} equals \code{1}. \cr
\cr
For regular relational operators, see \link{bc.rel}. \cr \cr
}
\examples{
x.dim <- c(4:2)
x.len <- prod(x.dim)
x.data <- sample(c(NA, 1.1:1000.1), x.len, TRUE)
x <- array(x.data, x.dim)
y <- array(1:50, c(4,1,1))

bc.i(x, y, "+")
bc.i(x, y, "-")
bc.i(x, y, "*")
bc.i(x, y, "gcd") # greatest common divisor
bc.i(x, y, "^")

bc.i(x, y, "==")
bc.i(x, y, "!=")
bc.i(x, y, "<")
bc.i(x, y, ">")
bc.i(x, y, "<=")
bc.i(x, y, ">=")
}
\seealso{
\link{broadcast_operators} \cr
}
