% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_samples.R
\name{as.mcmc.brmsfit}
\alias{as.mcmc.brmsfit}
\alias{as.mcmc}
\title{Extract posterior samples for use with the \pkg{coda} package}
\usage{
\method{as.mcmc}{brmsfit}(
  x,
  pars = NA,
  fixed = FALSE,
  combine_chains = FALSE,
  inc_warmup = FALSE,
  ...
)
}
\arguments{
\item{x}{An \code{R} object typically of class \code{brmsfit}}

\item{pars}{Names of parameters for which posterior samples
should be returned, as given by a character vector or regular expressions.
By default, all posterior samples of all parameters are extracted.}

\item{fixed}{Indicates whether parameter names
should be matched exactly (\code{TRUE}) or treated as
regular expressions (\code{FALSE}). Default is \code{FALSE}.}

\item{combine_chains}{Indicates whether chains should be combined.}

\item{inc_warmup}{Indicates if the warmup samples should be included.
Default is \code{FALSE}. Warmup samples are used to tune the
parameters of the sampling algorithm and should not be analyzed.}

\item{...}{currently unused}
}
\value{
If \code{combine_chains = TRUE} an \code{mcmc} object is returned.
  If \code{combine_chains = FALSE} an \code{mcmc.list} object is returned.
}
\description{
Extract posterior samples for use with the \pkg{coda} package
}
