% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-re.R
\name{gr}
\alias{gr}
\title{Set up basic grouping terms in \pkg{brms}}
\usage{
gr(..., by = NULL, dist = "gaussian")
}
\arguments{
\item{...}{One or more terms containing grouping factors.}

\item{by}{An optional factor variable, specifying sub-populations
of the groups. For each level of the \code{by} variable, 
a separate variance-covariance matrix will be fitted. 
Levels of the grouping factor must be nested in levels 
of the \code{by} variable.}

\item{dist}{Name of the distribution of the group-level effects.
Currently \code{"gaussian"} is the only option.}
}
\description{
Function used to set up a basic grouping term in \pkg{brms}.
The function does not evaluate its arguments --
it exists purely to help set up a model with grouping terms.
\code{gr} is called implicitly inside the package
and there is usually no need to call it directly.
}
\examples{
\dontrun{
# model using basic lme4-style formula
fit1 <- brm(count ~ Trt + (1|patient), data = epilepsy)
summary(fit1)

# equivalent model using 'gr' which is called anyway internally
fit2 <- brm(count ~ Trt + (1|gr(patient)), data = epilepsy)
summary(fit2)

# include Trt as a by variable
fit3 <- brm(count ~ Trt + (1|gr(patient, by = Trt)), data = epilepsy)
summary(fit3)
}

}
\seealso{
\code{\link{brmsformula}}
}
