% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autocor.R
\name{cor_arma}
\alias{cor_arma}
\alias{cor_arma-class}
\title{ARMA(p,q) correlation structure}
\usage{
cor_arma(formula = ~1, p = 0, q = 0, r = 0, cov = FALSE)
}
\arguments{
\item{formula}{A one sided formula of the form \code{~ t}, or \code{~ t | g},
specifying a time covariate \code{t} and, optionally, a grouping factor
\code{g}. A covariate for this correlation structure must be integer
valued. When a grouping factor is present in \code{formula}, the
correlation structure is assumed to apply only to observations within the
same grouping level; observations with different grouping levels are
assumed to be uncorrelated. Defaults to \code{~ 1}, which corresponds to
using the order of the observations in the data as a covariate, and no
groups.}

\item{p}{A non-negative integer specifying the autoregressive (AR) 
order of the ARMA structure. Default is 0.}

\item{q}{A non-negative integer specifying the moving average (MA) 
order of the ARMA structure. Default is 0.}

\item{r}{No longer supported.}

\item{cov}{A flag indicating whether ARMA effects should be estimated by
means of residual covariance matrices. This is currently only possible for
stationary ARMA effects of order 1. If the model family does not have
natural residuals, latent residuals are added automatically. If
\code{FALSE} (the default) a regression formulation is used that is
considerably faster and allows for ARMA effects of order higher than 1 but
is only available for \code{gaussian} models and some of its 
generalizations.}
}
\value{
An object of class \code{cor_arma}, representing an 
  autoregression-moving-average correlation structure.
}
\description{
This functions is a constructor for the \code{cor_arma} class, representing 
an autoregression-moving average correlation structure of order (p, q).
}
\examples{
cor_arma(~ visit | patient, p = 2, q = 2)

}
\seealso{
\code{\link{cor_ar}}, \code{\link{cor_ma}}
}
