% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{bridge_sampler.brmsfit}
\alias{bridge_sampler.brmsfit}
\alias{bridge_sampler}
\title{Log Marginal Likelihood via Bridge Sampling}
\usage{
\method{bridge_sampler}{brmsfit}(samples, ...)
}
\arguments{
\item{samples}{A \code{brmsfit} object.}

\item{...}{Additional arguments passed to 
\code{\link[bridgesampling:bridge_sampler]{bridge_sampler.stanfit}}.}
}
\description{
Computes log marginal likelihood via bridge sampling,
which can be used in the computation of bayes factors
and posterior model probabilities.
The \code{brmsfit} method is just a thin wrapper around
the corresponding method for \code{stanfit} objects.
}
\details{
Computing the marginal likelihood requires samples 
  of all variables defined in Stan's \code{parameters} block
  to be saved. Otherwise \code{bridge_sampler} cannot be computed.
  Thus, please set \code{save_all_pars = TRUE} in the call to \code{brm},
  if you are planning to apply \code{bridge_sampler} to your models.

  More details are provided under
  \code{\link[bridgesampling:bridge_sampler]{bridge_sampler}}.
}
\examples{
\dontrun{
# model with the treatment effect
fit1 <- brm(
  count ~ log_Age_c + log_Base4_c + Trt_c,
  data = epilepsy, family = negbinomial(), 
  prior = prior(normal(0, 1), class = b),
  save_all_pars = TRUE
)
summary(fit1)
bridge_sampler(fit1)

# model without the treatment effect
fit2 <- brm(
  count ~ log_Age_c + log_Base4_c,
  data = epilepsy, family = negbinomial(), 
  prior = prior(normal(0, 1), class = b),
  save_all_pars = TRUE
)
summary(fit2)
bridge_sampler(fit2)
}

}
\seealso{
\code{
  \link[brms:bayes_factor]{bayes_factor},
  \link[brms:post_prob]{post_prob}
}
}
