% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/families.R
\name{brmsfamily}
\alias{brmsfamily}
\alias{student}
\alias{bernoulli}
\alias{negbinomial}
\alias{geometric}
\alias{lognormal}
\alias{exponential}
\alias{weibull}
\alias{frechet}
\alias{gen_extreme_value}
\alias{exgaussian}
\alias{wiener}
\alias{Beta}
\alias{von_mises}
\alias{asym_laplace}
\alias{hurdle_poisson}
\alias{hurdle_negbinomial}
\alias{hurdle_gamma}
\alias{hurdle_lognormal}
\alias{zero_inflated_beta}
\alias{zero_inflated_poisson}
\alias{zero_inflated_negbinomial}
\alias{zero_inflated_binomial}
\alias{categorical}
\alias{cumulative}
\alias{sratio}
\alias{cratio}
\alias{acat}
\title{Special Family Functions for \pkg{brms} Models}
\usage{
brmsfamily(family, link = NULL, link_sigma = "log", link_shape = "log",
  link_nu = "logm1", link_phi = "log", link_kappa = "log",
  link_beta = "log", link_zi = "logit", link_hu = "logit",
  link_disc = "log", link_bs = "log", link_ndt = "log",
  link_bias = "logit", link_quantile = "logit", link_xi = "log1p")

student(link = "identity", link_sigma = "log", link_nu = "logm1")

bernoulli(link = "logit")

negbinomial(link = "log", link_shape = "log")

geometric(link = "log")

lognormal(link = "identity", link_sigma = "log")

exponential(link = "log")

weibull(link = "log", link_shape = "log")

frechet(link = "log", link_nu = "logm1")

gen_extreme_value(link = "identity", link_sigma = "log",
  link_xi = "log1p")

exgaussian(link = "identity", link_sigma = "log", link_beta = "log")

wiener(link = "identity", link_bs = "log", link_ndt = "log",
  link_bias = "logit")

Beta(link = "logit", link_phi = "log")

von_mises(link = "tan_half", link_kappa = "log")

asym_laplace(link = "identity", link_sigma = "log",
  link_quantile = "logit")

hurdle_poisson(link = "log")

hurdle_negbinomial(link = "log", link_shape = "log", link_hu = "logit")

hurdle_gamma(link = "log", link_shape = "log", link_hu = "logit")

hurdle_lognormal(link = "identity", link_sigma = "log", link_hu = "logit")

zero_inflated_beta(link = "logit", link_phi = "log", link_zi = "logit")

zero_inflated_poisson(link = "log", link_zi = "logit")

zero_inflated_negbinomial(link = "log", link_shape = "log",
  link_zi = "logit")

zero_inflated_binomial(link = "logit", link_zi = "logit")

categorical(link = "logit")

cumulative(link = "logit", link_disc = "log")

sratio(link = "logit", link_disc = "log")

cratio(link = "logit", link_disc = "log")

acat(link = "logit", link_disc = "log")
}
\arguments{
\item{family}{A character string naming the distribution
of the response variable be used in the model.
Currently, the following families are supported:
\code{gaussian}, \code{student}, \code{binomial}, 
\code{bernoulli}, \code{poisson}, \code{negbinomial}, 
\code{geometric}, \code{Gamma}, \code{lognormal}, 
\code{exgaussian}, \code{wiener}, \code{inverse.gaussian}, 
\code{exponential}, \code{weibull}, \code{frechet},
\code{Beta}, \code{von_mises},
\code{categorical}, \code{cumulative}, \code{cratio}, \code{sratio},
\code{acat}, \code{hurdle_poisson}, \code{hurdle_negbinomial}, 
\code{hurdle_gamma}, \code{hurdle_lognormal}, 
\code{zero_inflated_binomial}, \code{zero_inflated_beta},
\code{zero_inflated_negbinomial}, 
and \code{zero_inflated_poisson}.}

\item{link}{A specification for the model link function. 
This can be a name/expression or character string. 
See the 'Details' section for more information on link
functions supported by each family.}

\item{link_sigma}{Link of auxiliary parameter \code{sigma} if being predicted.}

\item{link_shape}{Link of auxiliary parameter \code{shape} if being predicted.}

\item{link_nu}{Link of auxiliary parameter \code{nu} if being predicted.}

\item{link_phi}{Link of auxiliary parameter \code{phi} if being predicted.}

\item{link_kappa}{Link of auxiliary parameter \code{kappa} if being predicted.}

\item{link_beta}{Link of auxiliary parameter \code{beta} if being predicted.}

\item{link_zi}{Link of auxiliary parameter \code{zi} if being predicted.}

\item{link_hu}{Link of auxiliary parameter \code{hu} if being predicted.}

\item{link_disc}{Link of auxiliary parameter \code{disc} if being predicted.}

\item{link_bs}{Link of auxiliary parameter \code{bs} if being predicted.}

\item{link_ndt}{Link of auxiliary parameter \code{ndt} if being predicted.}

\item{link_bias}{Link of auxiliary parameter \code{bias} if being predicted.}

\item{link_quantile}{Link of auxiliary parameter \code{quantile} if being predicted.}

\item{link_xi}{Link of auxiliary parameter \code{xi} if being predicted.}
}
\description{
Family objects provide a convenient way to specify the details of the models 
used by many model fitting functions. The familiy functions present here are 
currently for use with \pkg{brms} only and will NOT work with other model 
fitting functions such as \code{glm} or \code{glmer}. 
However, the standard family functions as decribed in
\code{\link[stats:family]{family}} will work with \pkg{brms}.
}
\details{
Family \code{gaussian} with \code{identity} link leads to linear regression. 
  Family \code{student} with \code{identity} link leads to 
  robust linear regression that is less influenced by outliers. 
  Families \code{poisson}, \code{negbinomial}, and \code{geometric} 
  with \code{log} link lead to regression models for count data. 
  Families \code{binomial} and \code{bernoulli} with \code{logit} link leads to 
  logistic regression and family \code{categorical} to multi-logistic regression 
  when there are more than two possible outcomes.
  Families \code{cumulative}, \code{cratio} ('contiuation ratio'), 
  \code{sratio} ('stopping ratio'), and \code{acat} ('adjacent category') 
  leads to ordinal regression. Families \code{Gamma}, \code{weibull}, 
  \code{exponential}, \code{lognormal}, \code{frechet}, and 
  \code{inverse.gaussian} can be used (among others) for survival regression.
  Families \code{weibull}, \code{frechet}, and \code{gen_extreme_value}
  ('generalized extreme value') allow for modeling extremes.
  Family \code{asym_laplace} allows for quantile regression when fixing
  the auxiliary \code{quantile} parameter to the quantile of interest.
  Family \code{exgaussian} ('exponentially modified Gaussian') is especially
  suited to model reaction times and the \code{wiener} family provides
  an implementation of the Wiener diffusion model. For this family,
  the main formula predicts the drift parameter 'delta' and
  all other parameters are modeled as auxiliary parameters 
  (see \code{\link[brms:brmsformula]{brmsformula}} for details).
  Families \code{hurdle_poisson}, \code{hurdle_negbinomial}, \code{hurdle_gamma}, 
  \code{hurdle_lognormal}, \code{zero_inflated_poisson},
  \code{zero_inflated_negbinomial}, \code{zero_inflated_binomial}, and
  \code{zero_inflated_beta} allow to estimate zero-inflated and hurdle models. 
  These models can be very helpful when there are many zeros in the data 
  that cannot be explained by the primary distribution of the response. 
  Families \code{hurdle_lognormal} and \code{hurdle_gamma} are 
  especially useful, as traditional \code{lognormal} or \code{Gamma}
  models cannot be reasonably fitted for data containing zeros in the response.
  
  In the following, we list all possible links for each family.
  The families \code{gaussian}, \code{student}, \code{exgaussian},
  \code{asym_laplace}, and \code{gen_extreme_value} accept the links 
  (as names) \code{identity}, \code{log}, and \code{inverse};
  families \code{poisson}, \code{negbinomial}, and \code{geometric} the links 
  \code{log}, \code{identity}, and \code{sqrt}; 
  families \code{binomial}, \code{bernoulli}, \code{Beta},
  \code{cumulative}, \code{cratio}, \code{sratio}, and \code{acat} 
  the links \code{logit}, \code{probit}, \code{probit_approx}, 
  \code{cloglog}, and \code{cauchit}; 
  family \code{categorical} the link \code{logit};
  families \code{Gamma}, \code{weibull}, \code{exponential}, and 
  \code{frechet} the links \code{log}, \code{identity}, and \code{inverse};
  family \code{lognormal} the links \code{identity} and \code{inverse};
  family \code{inverse.gaussian} the links \code{1/mu^2}, 
  \code{inverse}, \code{identity} and \code{log}; 
  families \code{hurdle_poisson}, \code{hurdle_negbinomial},
  \code{hurdle_gamma}, \code{zero_inflated_poisson}, and
  \code{zero_inflated_negbinomial} the link \code{log};
  families \code{wiener} and \code{hurdle_lognormal} the link \code{identity}.
  The first link mentioned for each family is the default.     
  
  Please note that when calling the \code{\link[stats:family]{Gamma}} 
  family function, the default link will be \code{inverse} not \code{log}. 
  Also, the \code{probit_approx} link cannot be used when calling the
  \code{\link[stats:family]{binomial}} family function. 
  
  The current implementation of \code{inverse.gaussian} models has some 
  convergence problems and requires carefully chosen prior distributions 
  to work efficiently. For this reason, we currently do not recommend
  to use the \code{inverse.gaussian} family, unless you really feel
  that your data requires exactly this type of model. \cr
}
\examples{
 # create a family object
 (fam1 <- student("log"))
 # alternatively use the brmsfamily function
 (fam2 <- brmsfamily("student", "log"))
 # both leads to the same object
 identical(fam1, fam2) 

}
\seealso{
\code{\link[brms:brm]{brm}}, 
  \code{\link[stats:family]{family}}
}
