% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{horseshoe}
\alias{horseshoe}
\title{Set up a horseshoe prior in \pkg{brms}}
\usage{
horseshoe(df = 1, scale_global = 1, df_global = 1, autoscale = TRUE)
}
\arguments{
\item{df}{Degrees of freedom of student-t prior of the 
local shrinkage parameters. Defaults to \code{1}.}

\item{scale_global}{Scale of the student-t prior of the global shrinkage 
parameter. Defaults to \code{1}. 
In linear models, \code{scale_global} will internally be 
multiplied by the residual standard deviation parameter \code{sigma}.}

\item{df_global}{Degrees of freedom of student-t prior of the 
global shrinkage parameter. Defaults to \code{1}.}

\item{autoscale}{Logical; indicating whether the horseshoe
prior should be scaled using the residual standard deviation
\code{sigma} if possible and sensible (defaults to \code{TRUE}).
Autoscaling is not applied for auxiliary parameters or 
when the model does not contain the parameter \code{sigma}.}
}
\value{
A character string obtained by \code{match.call()} with
  additional arguments.
}
\description{
Function used to set up a horseshoe prior for population-level effects 
in \pkg{brms}. The function does not evaluate its arguments --
it exists purely to help set up the model.
}
\details{
See \code{\link[brms:set_prior]{set_prior}} for more details
  about the horseshoe prior.
}
\examples{
set_prior(horseshoe(df = 3, scale_global = 2))

}
\seealso{
\code{\link[brms:set_prior]{set_prior}}
}
