% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/misc-methods.R
\name{VarCorr.brmsfit}
\alias{VarCorr}
\alias{VarCorr.brmsfit}
\alias{as.data.frame.brmsVarCorr}
\title{Extract variance and correlation components}
\usage{
\method{VarCorr}{brmsfit}(x, sigma = 1, estimate = "mean", as.list = TRUE,
  ...)

\method{as.data.frame}{brmsVarCorr}(x, ...)
}
\arguments{
\item{x}{An object of class \code{brmsfit}.}

\item{sigma}{Ignored (included for compatibility with 
\code{\link[nlme:VarCorr]{VarCorr}}).}

\item{estimate}{A character vector specifying which coefficients 
(e.g., \code{"mean"}, \code{"median"}, \code{"sd"}, or \code{"quantile"})
should be calculated for the extracted parameters.}

\item{as.list}{logical; Indicates if covariance 
and correlation matrices should be returned as 
lists of matrices (the default), or as 3-dimensional arrays.
We recommend not to set \code{as.list} to \code{FALSE}.}

\item{...}{Further arguments to be passed to the functions 
specified in \code{estimate}}
}
\value{
An object of class \code{brmsVarCorr}, 
which is a list of lists (one per grouping factor), 
each containing 3 elements: a matrix containing the standard deviations, 
a list of correlation matrices, and a list of covariance matrices. 
Can be coerced to a \code{data.frame} by using the \code{as.data.frame} method.
}
\description{
This function calculates the estimated standard deviations, 
correlations and covariances of the random-effects terms 
in a mixed-effects model of class \code{brmsfit}. 
For linear models, the residual standard deviations, 
correlations and covariances are also returned.
}
\examples{
\dontrun{
fit <- brm(count ~ log_Age_c + log_Base4_c * Trt_c + (1+Trt_c|visit), 
             data = epilepsy, family = "poisson", chains = 1)
## return the means of random effects covariances
(vc <- VarCorr(fit))
as.data.frame(vc)

## return 2.5\% and 97.5\% quantiles of random effects covariances
VarCorr(fit, estimate = "quantile", probs = c(0.025, 0.975))
}

}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}

