% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/generics.R
\name{marginal_smooths.brmsfit}
\alias{marginal_smooths}
\alias{marginal_smooths.brmsfit}
\title{Display Smooth Terms}
\usage{
\method{marginal_smooths}{brmsfit}(x, smooths = NULL, probs = c(0.025,
  0.975), ...)

marginal_smooths(x, ...)
}
\arguments{
\item{x}{An object usually of class \code{brmsfit}}

\item{smooths}{Optional character vector of smooth terms
to display. If \code{NULL} (the default) all smooth terms
are shown.}

\item{probs}{The quantiles to be used in the computation of credible
intervals (defaults to 2.5 and 97.5 percent quantiles)}

\item{...}{Currently ignored.}
}
\value{
For the \code{brmsfit} method, 
an object of class \code{brmsMarginalEffects}. See
\code{\link[brms:marginal_effects]{marginal_effects}} for 
more details and documentation of the related plotting function.
}
\description{
Display smooth \code{s} and \code{t2} terms of models
fitted with \pkg{brms}.
}
\details{
Smooth terms of more than one covariate cannot be
plotted yet, but this will follow in future version of \pkg{brms}.
}
\examples{
\dontrun{
set.seed(0) 
dat <- mgcv::gamSim(1, n = 200,scale = 2)
fit <- brm(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat)
# show all smooth terms
plot(marginal_smooths(fit), rug = TRUE, ask = FALSE)
# show only the smooth term s(x2)
plot(marginal_smooths(fit, smooths = "s(x2)"), ask = FALSE)
}

}

