% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_prior_simple.R
\name{brm_prior_simple}
\alias{brm_prior_simple}
\title{Simple prior for a \code{brms} MMRM}
\usage{
brm_prior_simple(
  data,
  formula,
  intercept = "student_t(3, 0, 2.5)",
  coefficients = "student_t(3, 0, 2.5)",
  sigma = "student_t(3, 0, 2.5)",
  correlation = "lkj(1)"
)
}
\arguments{
\item{data}{A tidy data frame with one row per patient per discrete
time point.}

\item{formula}{An object of class \code{"brmsformula"} from \code{\link[=brm_formula]{brm_formula()}}
or \code{brms::brmsformula()}. Should include the full parameterization
of the model, including fixed effects, residual correlation,
and heterogeneity in the discrete-time-specific residual variance
components.}

\item{intercept}{Character of length 1, Stan code for the prior
to set on the intercept parameter.}

\item{coefficients}{Character of length 1, Stan code for the prior
to set independently on each of the non-intercept model coefficients.}

\item{sigma}{Character of length 1, Stan code for the prior
to set independently on each of the log-scale standard deviation
parameters. Should be a symmetric prior in most situations.}

\item{correlation}{Character of length 1, Stan code for the prior
on the correlation matrix for the residuals of a given patient.
(Different patients are modeled as independent, and each
patient has the same correlation structure as each other patient.)
Should be an LKJ prior in most situations.}
}
\value{
A classed data frame with the \code{brms} prior.
}
\description{
Generate a simple prior for a \code{brms} MMRM.
}
\details{
In \code{\link[=brm_prior_simple]{brm_prior_simple()}}, you can separately choose priors for
the intercept, model coefficients, log-scale standard deviations,
and pairwise correlations between time points within patients.
However, each class of parameters is set as a whole. In other words,
\code{\link[=brm_prior_simple]{brm_prior_simple()}} cannot assign different priors
to different fixed effect parameters.
}
\examples{
set.seed(0L)
data <- brm_simulate_outline()
data <- brm_simulate_continuous(data, names = c("age", "biomarker"))
formula <- brm_formula(
  data = data,
  baseline = FALSE,
  baseline_time = FALSE
)
brm_prior_simple(
  data = data,
  formula = formula,
  intercept = "student_t(3, 0, 2.5)",
  coefficients = "normal(0, 10)",
  sigma = "student_t(2, 0, 4)",
  correlation = "lkj(2.5)"
)
}
\concept{priors}
