% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Landscape_Methods.R
\name{simulateThickMargins}
\alias{simulateThickMargins}
\title{Simulate thick margin to a landscape}
\usage{
simulateThickMargins(
  objectL,
  border_size = 200,
  prob = runif(1, 0.1, 0.9),
  mean_thickness = runif(1, 2, 20),
  v_thickness = 50
)
}
\arguments{
\item{objectL}{sf, sp or Landscape (earlier version of briskaR).}

\item{border_size}{A numeric, bbox margin}

\item{prob}{Probability to inflate a margin}

\item{mean_thickness}{Margin width expectation in meter}

\item{v_thickness}{Margin width variance in meter}
}
\value{
A \link[sp]{SpatialPolygonsDataFrame} object
}
\description{
Simulate thick margins as receptors in a landscape.
}
\details{
Margin width use a Gamma distribution with shape and scale parameters based on thickness mean and variance.
}
\examples{
\dontrun{
data(maize_65)
plot(maize.landscape)
landscape.margin <- simulateThickMargins(maize.landscape)
plot(landscape.margin) }

}
\seealso{
\link{simulateInitialPartition} and \link{simulateLandscape}
}
