% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/80_matrixplot.R
\name{matrixplot}
\alias{matrixplot}
\title{Displays a matrix of a particular graphic for bivariate data in a html file.}
\usage{
matrixplot(data, dataclass = NULL, diagram = NULL, dir = tempdir())
}
\arguments{
\item{data}{Data.frame. Default dataset to use for plot. Unquoted. If not
already a data.frame, it should be first coerced to by \emph{as.data.frame()}.}

\item{dataclass}{Character vector.
The types of data to be considered among the following:
\itemize{
  \item \emph{'logical'}
  \item \emph{'ordered'}
  \item \emph{'factor'}
  \item \emph{'numeric'}
  \item \emph{'datetime'}
  \item \emph{'character'}
}}

\item{diagram}{Character. A specific graphic to be presented within the ones
considered in the 2 input variables specimen available at
https://sciencegraph.github.io/brinton/articles/specimen2.html.}

\item{dir}{Directory in which the files are stored.}
}
\value{
Cause the side-effect of creating and displaying a temporary html
file that includes a grid of graphics. The variables of a dataset are first
grouped by the type of data, then, the variables matching the classes specified
in the dataclass parameter, are represented in each row and/or column of the matrix.
}
\description{
A matrixplot is a grid of a particular graphic showing bivariate relationships
between all pairs of variables of a certain(s) type(s) in a multivariate data set.
}
\examples{
if (interactive()) {
matrixplot(iris, dataclass = c("numeric","numeric"),
diagram="bw contour plot with data points")
}
}
