% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/70_plotup.R
\name{plotup}
\alias{plotup}
\title{Returns a ggplot object of a specific graphic explicitly called by name.}
\usage{
plotup(data, vars, diagram, output = "plots pane", dir = tempdir())
}
\arguments{
\item{data}{Data.frame. Default dataset to use for plot. If not already a
data.frame, it should be first coerced to by [as.data.frame()].}

\item{vars}{Character. A variable within the dataset.}

\item{diagram}{Character. A specific graphic to be presented within the ones
considered by the 'logical', 'ordered', 'factor', 'character', 'datetime' and 'numeric'
arguments of the 'wideplot()' function.}

\item{output}{Character. Type of output.
\itemize{
  \item \emph{'html'}: Creates and displays a html file with the specific graphic.
  \item \emph{'plots pane'}: Default output, a ggplot2 object in RStudio's plots pane.
  \item \emph{'console'}: Prints the code that produces the specific graphic.
}}

\item{dir}{Directory in which the files are stored.}
}
\value{
This function returns a c('gg', 'ggplot') object, but if the 'output' argument
is set to it 'html' or 'console', the function cause a side-effect: either creating and
displaying a temporary html file, or printing the ggplot2 code to the console.

the function cause a side-effect: either creating and displaying a temporary html file, or printing the ggplot2 code to the console.can have three outputs: by default it produces a particular graphic,
but it can also be represented into the RStudio's plots pane, or can return the code to produce it.
}
\description{
In order to present the graphic, the user must define a dataset, at
least one variable whitin this dataset and a compatible type of graphic.
Future work will include graphics that involve more number and
combinations of types of variables.
}
\examples{
plotup(iris, "Petal.Width", "color heatmap")
plotup(iris, "Petal.Width", "color heatmap", output = "console")
if (interactive()) {
plotup(iris, "Petal.Width", "color heatmap", output = "html")
}
}
