% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/databricks-dbi.R
\name{dbConnect,DatabricksDriver-method}
\alias{dbConnect,DatabricksDriver-method}
\title{Connect to Databricks SQL Warehouse}
\usage{
\S4method{dbConnect}{DatabricksDriver}(
  drv,
  warehouse_id,
  catalog = NULL,
  schema = NULL,
  staging_volume = NULL,
  max_active_connections = 30,
  fetch_timeout = 300,
  token = db_token(),
  host = db_host(),
  ...
)
}
\arguments{
\item{drv}{A DatabricksDriver object}

\item{warehouse_id}{ID of the SQL warehouse to connect to}

\item{catalog}{Optional catalog name to use as default}

\item{schema}{Optional schema name to use as default}

\item{staging_volume}{Optional volume path for large dataset staging}

\item{max_active_connections}{Maximum number of concurrent download
connections when fetching query results (default: 30)}

\item{fetch_timeout}{Timeout in seconds for downloading each result chunk
(default: 300)}

\item{token}{Authentication token (defaults to db_token())}

\item{host}{Databricks workspace host (defaults to db_host())}

\item{...}{Additional arguments (ignored)}
}
\value{
A DatabricksConnection object
}
\description{
Connect to Databricks SQL Warehouse
}
