% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plrtest.R
\name{plrtest.mdyplFit}
\alias{plrtest.mdyplFit}
\alias{plrtest}
\title{Penalized likelihood ratio test for \code{\link[=mdyplFit]{"mdyplFit"}} objects}
\usage{
\method{plrtest}{mdyplFit}(object1, object2, hd_correction = FALSE, ...)
}
\arguments{
\item{object1}{a \code{\link[=mdyplFit]{"mdyplFit"}} object}

\item{object2}{a \code{\link[=mdyplFit]{"mdyplFit"}} object}

\item{hd_correction}{if \code{FALSE} (default), then the summary
corresponding to standard asymptotics is computed. If \code{TRUE}
then the high-dimensionality corrections in Sterzinger &
Kosmidis (2024) are employed to updates estimates, estimated
standard errors, z-statistics. See Details.}

\item{...}{further arguments to be passed to methods. Currently not used.}
}
\description{
Computes the Diaconis-Ylvisaker prior penalized likelihood ratio
test statistic or its adjusted version using high-dimensionality
correction under proportional asymptotics. Associated p-values are
also computed using a chi squared distribution.
}
\details{
Both \code{object1} and \code{object2} should have been fitted using the
\code{\link[=mdyplFit]{mdyplFit()}} method for \code{\link[=glm]{glm()}}, and the same shrinkage parameter
\code{alpha}; see \code{\link[=mdyplFit]{mdyplFit()}} and \code{\link[=mdyplControl]{mdyplControl()}} for setting \code{alpha}.

If \code{hd_correction = TRUE} then the deviance and the associated
p-value are adjusted using a high-dimensionality correction under
proportional asymptotics as in Sterzinger & Kosmidis (2024); see
\code{\link[=summary.mdyplFit]{summary.mdyplFit()}}.
}
\references{
Sterzinger P, Kosmidis I (2024). Diaconis-Ylvisaker prior
penalized likelihood for \eqn{p/n \to \kappa \in (0,1)} logistic
regression. \emph{arXiv}:2311.07419v2, \url{https://arxiv.org/abs/2311.07419}.
}
\seealso{
\code{\link[=mdyplFit]{mdyplFit()}}, \code{\link[=summary.mdyplFit]{summary.mdyplFit()}}, \code{\link[=mdypl_control]{mdypl_control()}}
}
\author{
Ioannis Kosmidis \verb{[aut, cre]} \email{ioannis.kosmidis@warwick.ac.uk}
}
