% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brglmControl.R, R/zzz_conventions.R
\name{brglmControl}
\alias{brglmControl}
\alias{brglm_control}
\title{Auxiliary function for \code{\link{glm}} fitting using the
\code{\link{brglmFit}} method.}
\usage{
brglmControl(epsilon = 1e-06, maxit = 100, trace = FALSE,
  type = c("AS_mixed", "AS_mean", "AS_median", "correction", "ML"),
  transformation = "identity", slowit = 1,
  response_adjustment = NULL, max_step_factor = 12)

brglm_control(epsilon = 1e-06, maxit = 100, trace = FALSE,
  type = c("AS_mixed", "AS_mean", "AS_median", "correction", "ML"),
  transformation = "identity", slowit = 1,
  response_adjustment = NULL, max_step_factor = 12)
}
\arguments{
\item{epsilon}{positive convergence tolerance epsilon. Default is \code{1e-06}.}

\item{maxit}{integer giving the maximal number of iterations
allowed. Default is \code{100}.}

\item{trace}{logical indicating if output should be produced for
each iteration. Default is \code{FALSE}.}

\item{type}{the type of fitting method to be used. The options are
\code{AS_mean} (mean-bias reducing adjusted scores),
\code{AS_median} (median-bias reducting adjusted scores),
\code{AS_mixed} (bias reduction using mixed score adjustents;
default), \code{correction} (asymptotic bias correction) and
\code{ML} (maximum likelihood).}

\item{transformation}{the transformation of the dispersion to be
estimated. Default is \code{identity}. See Details.}

\item{slowit}{a positive real used as a multiplier for the
stepsize. The smaller it is the smaller the steps are. Default is \code{1}.}

\item{response_adjustment}{a (small) positive constant or a vector
of such. Default is \code{NULL}. See Details.}

\item{max_step_factor}{the maximum number of step halving steps to
consider. Default is \code{12}.}
}
\value{
a list with components named as the arguments, including
    symbolic expressions for the dispersion transformation
    (\code{Trans}) and its inverse (\code{inverseTrans})
}
\description{
Typically only used internally by \code{\link{brglmFit}}, but may
be used to construct a \code{control} argument.
}
\details{
\code{\link{brglmControl}} provides default values and
    sanity checking for the various constants that control the
    iteration and generally the behaviour of
    \code{\link{brglmFit}}.

     When \code{trace} is true, calls to \code{cat} produce the
     output for each iteration.  Hence, \code{options(digits = *)}
     can be used to increase the precision.

     \code{transformation} sets the transformation of the
     dispersion parameter for which the bias reduced estimates are
     computed. Can be one of "identity", "sqrt", "inverse", "log"
     and "inverseSqrt". Custom transformations are accommodated by
     supplying a list of two expressions (transformation and
     inverse transformation). See the examples for more details.

     The value of \code{response_adjustment} is only relevant if
     \code{\link{brglmFit}} is called with \code{start = NULL}, and
     \code{family} is \code{\link{binomial}} or
     \code{\link{poisson}}. For those models, an initial maximum
     likelihood fit is obtained on adjusted data to provide
     starting values for the iteration in \code{brglmFit}. The
     value of \code{response_adjustment} governs how the data is
     adjusted. Specifically, if \code{family} is \code{binomial},
     then the responses and totals are adjusted by and \code{2 *
     response_adjustment}, respectively; if \code{family} is
     \code{poisson}, then the responses are adjusted by and
     \code{response_adjustment}. \code{response_adjustment = NULL}
     (default) is equivalent to setting it to
     "number of parameters"/"number of observations". 
     

\code{brglm_control} is an alias to \code{brglmControl}.
}
\examples{

data("coalition", package = "brglm2")
## The maximum likelihood fit with log link
coalitionML <- glm(duration ~ fract + numst2, family = Gamma, data = coalition)

## Bias reduced estimation of the dispersion parameter
coalitionBRi <- glm(duration ~ fract + numst2, family = Gamma, data = coalition,
                    method = "brglmFit")
coef(coalitionBRi, model = "dispersion")

## Bias reduced estimation of log(dispersion)
coalitionBRl <- glm(duration ~ fract + numst2, family = Gamma, data = coalition,
                    method = "brglmFit", transformation = "log")
coef(coalitionBRl, model = "dispersion")

## Just for illustration: Bias reduced estimation of dispersion^0.25
my_transformation <- list(expression(dispersion^0.25), expression(transformed_dispersion^4))
coalitionBRc <- update(coalitionBRi, transformation = my_transformation)
coef(coalitionBRc, model = "dispersion")

}
\seealso{
\code{\link{brglm_fit}} and \code{\link{glm.fit}}
}
\author{
Ioannis Kosmidis \email{ioannis.kosmidis@warwick.ac.uk}
}
