% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wemgsc.R
\name{model.gsa}
\alias{model.gsa}
\title{Estimating change-points in the piecewise-constant mean of a noisy data sequence with auto-regressive noise via gappy Schwarz algorithm}
\usage{
model.gsa(cptpath.object, p.max = 10, pen = log(length(cptpath.object$x))^1.01)
}
\arguments{
\item{cptpath.object}{A solution-path object, returned by a \code{sol.wcm} routine. Note that the field \code{cptpath.object$x} contains the input data sequence.}

\item{p.max}{The maximum AR order. The default is \code{p.max = 10}.}

\item{pen}{Penalty used for the Schwarz criterion. \code{log(length(cptpath.object$x))^1.01} is used as default.}
}
\value{
An S3 object of class \code{cptmodel}, which contains the following fields: 
\item{solution.path}{The solution path method used to obtain \code{cptpath.object}, here its value is \code{"wcm"}}
\item{model.selection}{The model selection method used to return the final change-point estimators object, here its value is \code{"gsa"}}
\item{no.of.cpt}{The number of estimated change-points in the piecewise-constant mean of the vector \code{cptpath.object$x}}
\item{cpts}{The locations of estimated change-points in the piecewise-constant mean of the vector \code{cptpath.object$x}. These are the end-points of the corresponding constant-mean intervals}
\item{est}{An estimate of the piecewise-constant mean of the vector \code{cptpath.object$x}; the values are the sample means of the data (replicated a suitable number of times) between each pair of consecutive detected change-points}
}
\description{
This function estimates the number and locations of change-points in the piecewise-constant mean of a noisy data sequence with auto-regressive noise via gappy Schwarz algorithm
from a candidate model sequence generated by \code{sol.wcm}.
}
\details{
From the largest to the smallest (i.e. empty) candidate models generated by \code{sol.wcm}, 
gappy Schwarz algorithm locally evaluates the Schwarz criterion (SC, under piecewise constant signal + AR(p) noise model, with the AR order p to be determined adaptively) and its modification SC0
on each segment determined by the next smallest candidate model. It selects the larger model as the final model if over each segment, all newly introduced estimators are deemed `significant' according to SC and SC0; see Cho and Fryzlewicz (2023) for details.
}
\examples{
set.seed(111)
f <- rep(c(0, 5, 2, 8, 1, -2), c(100, 200, 200, 50, 200, 250))
x <- f + arima.sim(list(ar = c(.75, -.5), ma = c(.8, .7, .6, .5, .4, .3)), n = length(f), sd = 1)
model.gsa(sol.wcm(x))
}
\references{
H. Cho & P. Fryzlewicz (2024) Multiple change point detection under serial dependence: Wild contrast maximisation and gappy Schwarz algorithm. \emph{Journal of Time Series Analysis}, 45(3): 479--494.
}
\seealso{
\code{\link{sol.wcm}}
}
