% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/communicability.R
\name{communicability}
\alias{communicability}
\title{Calculate communicability}
\usage{
communicability(g, weights = NULL)
}
\arguments{
\item{g}{An \code{igraph} graph object}

\item{weights}{Numeric vector of edge weights; if \code{NULL} (the default),
and if the graph has edge attribute \code{weight}, then that will be used.
To avoid using weights, this should be \code{NA}.}
}
\value{
A numeric matrix of the communicability
}
\description{
\code{communicability} calculates the communicability of a network, a measure
which takes into account all possible paths (including non-shortest paths)
between vertex pairs.
}
\details{
The communicability \eqn{G_{pq}} is a weighted sum of the number of walks
from vertex \emph{p} to \emph{q} and is calculated by taking the exponential
of the adjacency matrix \emph{A}:
\deqn{G_{pq} = \sum_{k=0}^{\infty} \frac{(\mathbf{A}^k)_{pq}}{k!} =
(e^{\mathbf{A}})_{pq}}
where \eqn{k} is \emph{walk} length.

For weighted graphs with \eqn{D = diag(d_i)} a diagonal matrix of vertex
strength,
\deqn{G_{pq} = (e^{\mathbf{D}^{-1/2} \mathbf{A} \mathbf{D}^{-1/2}})_{pq}}
}
\references{
Estrada, E. and Hatano, N. (2008) Communicability in complex
  networks. \emph{Physical Review E}. \bold{77}, 036111.
  \doi{10.1103/PhysRevE.77.036111}

Crofts, J.J. and Higham, D.J. (2009) A weighted communicability
  measure applied to complex brain networks. \emph{J. R. Soc. Interface}.
  \bold{6}, 411--414. \doi{10.1098/rsif.2008.0484}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
